/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.email.EmailAdapterSender;
import com.savvion.sbm.bizlogic.email.EmailManager;
import com.savvion.sbm.bizlogic.message.BLMessage;
import com.savvion.sbm.bizlogic.message.EmailMessage;
import com.savvion.sbm.bizlogic.server.Notify;
import com.savvion.sbm.bizlogic.server.WFAtomicInstance;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFDataSlotInstance;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.dms.svo.Document;
import com.savvion.sbm.util.MessageFactory;
import com.savvion.sbm.util.ResourceUtil;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.URLHexCoder;
import com.tdiinc.userManager.User;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class EmailComposer {
    private String returnPage = null;
    private String serverURL = null;
    private String servletRoot = null;
    private String bizsoloServletRoot = null;
    private final Map<Locale, MessageFactory> blEmailMsgFactories = new HashMap<Locale, MessageFactory>();
    private static EmailComposer self = null;
    private static final int INPUT = 1;
    private static final int OUTPUT = 2;

    private EmailComposer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EmailComposer self() {
        if (self != null) return self;
        Class<EmailComposer> clazz = EmailComposer.class;
        synchronized (EmailComposer.class) {
            if (self != null) return self;
            self = new EmailComposer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public boolean sendWorkitemSubprocessCompleted(String winame, String spname, String creator, String email, String outputs) {
        if (!BLUtil.self().isSendEmailForTask()) {
            return false;
        }
        boolean isSuccessful = false;
        if (email == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{creator});
            isSuccessful = false;
        } else {
            String subject = this.getSubjectForWorkitemSubprocessCompleted(winame);
            String content = this.getMessageForWorkitemSubprocessCompleted(winame, spname, creator, outputs);
            EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{email});
            isSuccessful = this.notify("EmailComposer.sendWorkitemSubprocessCompleted()", emsg);
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{email, subject, "EmailComposer:sendWorkitemSubprocessCompleted(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean sendAssignedTask(WFProcessContext pCtx, long wiid, String emailAddr, String warning) {
        boolean isSuccessful = false;
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        String wiPerformer = wieb.getPerformer();
        if (emailAddr == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{wiPerformer});
        } else {
            isSuccessful = BLUtil.senderClass != null ? this.sendAssignedTaskFromUserEA(pCtx, wiid, wiPerformer, emailAddr, warning, true) : EmailManager.sendAssignedTask(pCtx, wiid, emailAddr, warning);
        }
        return isSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendAssignedTaskFromUserEA(WFProcessContext pCtx, long wiid, String performer, String emailAddr, String warning, boolean isAssignTaskEmail) {
        boolean isSuccessful = true;
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        long wsid = wieb.getWorkStepID();
        Hashtable processContextDataList = this.collectProcessData(pCtx, wiid, performer, emailAddr, warning, isAssignTaskEmail);
        Object oSender = null;
        EmailAdapterSender adapterSender = null;
        Constructor oConstructor = null;
        try {
            oConstructor = BLUtil.senderClass.getConstructor(String.class);
            oSender = oConstructor.newInstance(new String(SBMControl.util.SMTPServer));
            adapterSender = oSender;
        }
        catch (Exception ex) {
            BLControl.logger.errorKey("BizLogic_ERR_3814", "EmailComposer.sendAssignedTaskFromUserEA", (Throwable)ex, new Object[]{BLUtil.senderClass});
        }
        try {
            if (adapterSender != null) {
                adapterSender.init();
                adapterSender.setProcessContextDataList(processContextDataList);
                adapterSender.setInputDataslotList(this.getDataSlotsInfo(pCtx, wsid, 1));
                adapterSender.setOutputDataslotList(this.getDataSlotsInfo(pCtx, wsid, 2));
                adapterSender.prepareData();
                adapterSender.prepareEmailSubject();
                adapterSender.prepareEmailContent();
                adapterSender.setMailTo(emailAddr);
                adapterSender.send();
            } else {
                isSuccessful = false;
                BLControl.logger.errorKey("BizLogic_ERR_3815", "EmailComposer.sendAssignedTaskFromUserEA", null, new Object[]{emailAddr, wiid});
            }
        }
        catch (Exception e) {
            isSuccessful = false;
            BLControl.logger.errorKey("BizLogic_ERR_3815", "EmailComposer.sendAssignedTaskFromUserEA", (Throwable)e, new Object[]{emailAddr, wiid});
        }
        finally {
            if (adapterSender != null) {
                adapterSender.clean();
            }
        }
        return isSuccessful;
    }

    private Hashtable getDataSlotsInfo(WFProcessContext pCtx, long wsid, int type) {
        HashMap hm = null;
        hm = type == 1 ? WFWorkstepInstance.single().getInputSlotValueByName(pCtx, wsid) : WFWorkstepInstance.single().getOutputSlotValueByName(pCtx, wsid);
        Hashtable ht = new Hashtable();
        if (hm != null && !hm.isEmpty()) {
            ht = new Hashtable(hm.size());
            String dsname = null;
            Object dsvalue = null;
            Map.Entry entry2 = null;
            WFDataslot ds = null;
            Vector<Object> v = null;
            for (Map.Entry entry2 : hm.entrySet()) {
                Vector choices;
                dsname = (String)entry2.getKey();
                dsvalue = entry2.getValue();
                ds = pCtx.getWorkstep(wsid).getDataslot(dsname);
                v = new Vector<Object>(3);
                v.addElement(ds.getType());
                if (dsvalue != null) {
                    v.addElement(dsvalue.toString());
                } else {
                    v.addElement("NULL");
                }
                if (ds.isDocument()) {
                    List docList = WFDataSlotInstance.self().getDocumentList(pCtx, dsname);
                    if (docList != null && !docList.isEmpty()) {
                        StringBuffer docNames = new StringBuffer(100);
                        Vector<Document> docs = new Vector<Document>(docList.size());
                        Document item2 = null;
                        for (Document item2 : docList) {
                            docNames.append(item2.getName());
                            docNames.append(",");
                            docs.addElement(item2);
                        }
                        v.setElementAt(docNames, 1);
                        v.addElement(docs);
                    }
                } else if (ds.hasChoices() && (choices = ds.getChoices()) != null && !choices.isEmpty()) {
                    v.addElement(choices);
                }
                ht.put(dsname, v);
            }
        }
        return ht;
    }

    private Hashtable collectProcessData(WFProcessContext pCtx, long wiid, String performer, String performerEmailAddress, String warning, boolean isAssignTaskEmail) {
        Hashtable<String, String> processContextDataList = new Hashtable<String, String>();
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        long wsid = wieb.getWorkStepID();
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (warning != null) {
            BLConstants.single();
            processContextDataList.put("SYSTEMMESSAGE", warning);
        } else {
            BLConstants.single();
            processContextDataList.put("SYSTEMMESSAGE", "<NULL>");
        }
        BLConstants.single();
        processContextDataList.put("PROCESSINSTANCENAME", pCtx.getProcessInstanceName());
        BLConstants.single();
        processContextDataList.put("PROCESSINSTANCEID", String.valueOf(pCtx.getProcessInstanceID()));
        BLConstants.single();
        processContextDataList.put("WORKSTEPNAME", ws.getName());
        BLConstants.single();
        processContextDataList.put("WORKITEMNAME", wieb.getName());
        BLConstants.single();
        processContextDataList.put("WORKITEMID", String.valueOf(wieb.getId()));
        if (performer != null) {
            BLConstants.single();
            processContextDataList.put("PERFORMERNAME", performer);
        } else {
            BLConstants.single();
            processContextDataList.put("PERFORMERNAME", "<NULL>");
        }
        if (performerEmailAddress != null) {
            BLConstants.single();
            processContextDataList.put("PERFORMEREMAILADDRESS", performerEmailAddress);
        } else {
            BLConstants.single();
            processContextDataList.put("PERFORMEREMAILADDRESS", "<NULL>");
        }
        BLConstants.single();
        processContextDataList.put("MAILSERVER", SBMControl.util.SMTPServer);
        BLConstants.single();
        processContextDataList.put("BIZSITEURL", SBMControl.util.BizSiteLoginURL);
        BLConstants.single();
        processContextDataList.put("FROMADDRESS", BLUtil.BLEMAILACCOUNT);
        String instruction = ws.getInstruction();
        if (instruction == null) {
            BLConstants.single();
            processContextDataList.put("WORKSTEPINSTRUCTION", "<NULL>");
        } else {
            BLConstants.single();
            processContextDataList.put("WORKSTEPINSTRUCTION", instruction);
        }
        BLConstants.single();
        processContextDataList.put("DOCUMENTREPOSITORYURL", SBMControl.util.docServerURL);
        if (ws.getEmailSupport()) {
            BLConstants.single();
            processContextDataList.put("ISEMAILNOTIFICATION", "false");
        } else {
            BLConstants.single();
            processContextDataList.put("ISEMAILNOTIFICATION", "true");
        }
        if (isAssignTaskEmail) {
            BLConstants.single();
            processContextDataList.put("ISASSIGNTASKEMAIL", "true");
        } else {
            BLConstants.single();
            processContextDataList.put("ISASSIGNTASKEMAIL", "false");
        }
        return processContextDataList;
    }

    public boolean sendAvailableTask(WFProcessContext pCtx, long wiid, String performerEmail, String performerId) {
        boolean isSuccessful = false;
        if (performerEmail == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{performerId});
        } else {
            isSuccessful = BLUtil.senderClass != null ? this.sendAssignedTaskFromUserEA(pCtx, wiid, performerId, performerEmail, "", false) : EmailManager.sendAvailableTask(pCtx, wiid, performerEmail, performerId);
        }
        return isSuccessful;
    }

    public boolean sendDueDate(WFProcessContext pCtx, long wsid, String emailAddress) {
        if (!BLUtil.self().isSendEmailForTask()) {
            return false;
        }
        boolean isSuccessful = false;
        if (emailAddress == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{emailAddress});
        } else {
            String subject = null;
            String content = null;
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
            if (wsieb.getType() == 102) {
                Vector wiids = WorkItemDAO.getIDByWorkStepInstance(pCtx.getProcessInstanceID(), wsid, -1);
                for (int ix = wiids.size() - 1; ix >= 0; --ix) {
                    long wiid = (Long)wiids.elementAt(ix);
                    WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
                    String performer = wieb.getPerformer();
                    if (wieb.getState() == 31) continue;
                    subject = this.getSubjectForTaskDue(wieb.getName());
                    content = this.getMessageForTaskDue(wieb.getName(), performer, false);
                    EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
                    isSuccessful = this.notify("EmailComposer.sendDueDate()", emsg);
                    User user = BLUtil.getUser((String)performer);
                    String performerEmail = user.getAttribute("EMAIL");
                    if (performerEmail == null) {
                        BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{performer});
                        isSuccessful = false;
                        continue;
                    }
                    content = this.getMessageForTaskDue(wieb.getName(), performer, true);
                    emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
                    isSuccessful = this.notify("EmailComposer.sendDueDate()", emsg);
                    if (!BLControl.util.DEBUG_ENGINE || !isSuccessful) continue;
                    BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendDueDate(..)"});
                }
            } else if (wsieb.getState() != 21) {
                String taskName = pCtx.getProcessInstanceName() + "::" + wsieb.getName();
                subject = this.getSubjectForTaskDue(taskName);
                content = this.getMessageForTaskDue(taskName, wsieb.getPerformer(), false);
                EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
                isSuccessful = this.notify("EmailComposer.sendDueDate()", emsg);
                if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                    BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendDueDate(..)"});
                }
            }
        }
        return isSuccessful;
    }

    public boolean sendWISuspendProblem(WFProcessContext pCtx, long wiid, String emailAddress) {
        if (!BLUtil.self().isSendEmailForTask()) {
            return false;
        }
        boolean isSuccessful = false;
        if (emailAddress == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{emailAddress});
        } else {
            WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
            String subject = this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_024", new Object[]{wieb.getName(), pCtx.getProcessInstanceName()}, false);
            EmailMessage emsg = new EmailMessage(subject, subject, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
            isSuccessful = this.notify("EmailComposer.sendWISuspendProblem()", emsg);
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendWISuspendProblem(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean sendEPProblem(WFProcessContext pCtx, long wsid, String emailAddress, Throwable th, String reason) {
        if (!BLControl.util.sendEmailOnError) {
            return false;
        }
        boolean isSuccessful = false;
        if (emailAddress == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{emailAddress});
        } else {
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
            String subject = this.getSubjectForEPProblem(wsieb.getName(), pCtx.getProcessInstanceName());
            String content = this.getMessageForEPProblem(pCtx.getProcessInstanceName(), wsieb.getName(), wsieb.getPerformer(), SBMUtil.getStackTrace((Throwable)th));
            EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
            try {
                isSuccessful = this.notify("EmailComposer.sendEPProblem()", emsg);
            }
            catch (BizLogicException e) {
                if (!BLUtil.self().ignoreEmailErrors) {
                    throw e;
                }
                this.logError(e, "EmailComposer.sendEPProblem()");
            }
            catch (Throwable ex) {
                if (!BLUtil.self().ignoreEmailErrors) {
                    throw new BizLogicException("BizLogic_ERR_3565", "EmailComposer.sendEPProblem()", ex);
                }
                this.logError(ex, "EmailComposer.sendEPProblem()");
            }
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendEPProblem(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean sendWSSuspendProblem(WFProcessContext pCtx, long wsid, String emailAddress, Throwable th, String reason) {
        if (!BLControl.util.sendEmailOnError) {
            return false;
        }
        boolean isSuccessful = false;
        if (emailAddress == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{emailAddress});
        } else {
            String subject;
            WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
            int suspendState = wsieb.getSuspendState();
            String piName = pCtx.getProcessInstanceName();
            String wsName = wsieb.getName();
            String content = subject = this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_025", new Object[]{wsName, piName}, false);
            if (wsieb.getType() == 107) {
                if (suspendState == 3) {
                    return this.sendEPProblem(pCtx, wsid, emailAddress, th, reason);
                }
            }
            BLConstants.single();
            if (suspendState == 1) {
                content = this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_029", new Object[]{wsName, piName}, false);
            } else {
                BLConstants.single();
                if (suspendState == 2) {
                    content = this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_030", new Object[]{wsName, piName}, false);
                } else {
                    BLConstants.single();
                    if (suspendState == 4) {
                        content = this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_031", new Object[]{wsName, piName}, false);
                    }
                }
            }
            EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
            try {
                isSuccessful = this.notify("EmailComposer.sendWSSuspendProblem()", emsg);
            }
            catch (BizLogicException e) {
                if (!BLUtil.self().ignoreEmailErrors) {
                    throw e;
                }
                this.logError(e, "EmailComposer.sendWSSuspendProblem()");
            }
            catch (Throwable ex) {
                if (!BLUtil.self().ignoreEmailErrors) {
                    throw new BizLogicException("BizLogic_ERR_3565", "EmailComposer.sendWSSuspendProblem()", ex);
                }
                this.logError(ex, "EmailComposer.sendWSSuspendProblem()");
            }
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendWSSuspendProblem(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean sendPISuspendProblem(String emailAddress, String piName) {
        if (!BLUtil.self().isSendEmailForTask()) {
            return false;
        }
        boolean isSuccessful = false;
        if (emailAddress == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{emailAddress});
        } else {
            String subject = this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_026", new Object[]{piName}, false);
            EmailMessage emsg = new EmailMessage(subject, subject, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
            try {
                isSuccessful = this.notify("EmailComposer.sendPISuspendProblem()", emsg);
            }
            catch (BizLogicException e) {
                if (!BLUtil.self().ignoreEmailErrors) {
                    throw e;
                }
                this.logError(e, "EmailComposer.sendPISuspendProblem()");
            }
            catch (Throwable ex) {
                if (!BLUtil.self().ignoreEmailErrors) {
                    throw new BizLogicException("BizLogic_ERR_3565", "EmailComposer.sendWSSuspendProblem()", ex);
                }
                this.logError(ex, "EmailComposer.sendPISuspendProblem()");
            }
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendPISuspendProblem(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean sendBLSuspendProblem(String emailAddress) {
        return this.sendBLSuspendProblem(emailAddress, "");
    }

    public boolean sendBLSuspendProblem(String emailAddress, String errMessage) {
        if (!BLControl.util.sendEmailOnError) {
            return false;
        }
        boolean isSuccessful = false;
        if (emailAddress == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{emailAddress});
        } else {
            String subject;
            String content = subject = this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_027", new Object[]{BLControl.serverID}, false);
            if (errMessage != null) {
                content = content + "\n" + errMessage;
            }
            EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
            isSuccessful = this.notify("EmailComposer.sendBLSuspendProblem()", emsg);
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendBLSuspendProblem(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean sendBLResumed(String emailAddress) {
        if (!BLControl.util.sendEmailOnError) {
            return false;
        }
        boolean isSuccessful = false;
        if (emailAddress == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{emailAddress});
        } else {
            String subject = this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_028", new Object[]{BLControl.serverID}, false);
            EmailMessage emsg = new EmailMessage(subject, subject, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
            isSuccessful = this.notify("EmailComposer.sendBLResumed()", emsg);
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendBLResumed(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean sendMgrProblem(String emailAddress, String ptname, String winame, String manager) {
        boolean isSuccessful = false;
        if (emailAddress == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{manager});
        } else {
            String subject = this.getSubjectForMgrProblem(manager);
            String content = this.getMessageForMgrProblem(ptname, winame, manager);
            EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
            isSuccessful = this.notify("EmailComposer.sendMgrProblem()", emsg);
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendMgrProblem(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean sendEmailForJavaScript(String emailAddress, String subject, String content) {
        boolean isSuccessful = false;
        if (emailAddress == null) {
            throw new BizLogicException("BizLogic_ERR_661", "EmailComposer::sendEmailForJavaScript", new Object[]{emailAddress});
        }
        EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
        isSuccessful = Notify.self().send((BLMessage)emsg);
        if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
            BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendEmailForJavaScript(..)"});
        }
        return isSuccessful;
    }

    public boolean sendInvalidPerformer(String piname, String wsname, String winame, String performer, boolean availFor, String emailAddress, Locale recipientLocale) {
        boolean isSuccessful = false;
        if (emailAddress == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{performer});
        } else {
            String subject = this.getSubjectForInvalidPerformer(performer, availFor, recipientLocale);
            String content = this.getMessageForInvalidPerformer(piname, wsname, winame, performer, recipientLocale);
            EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
            isSuccessful = this.notify("EmailComposer.sendInvalidPerformer(S, S, S, S, b, S)", emsg);
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendInvalidPerformer(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean sendInvalidPerformer(String piname, String wsname, String performer, boolean availFor, String emailAddress, Locale recipientLocale) {
        Vector<String> perfs = new Vector<String>();
        perfs.add(performer);
        return this.sendInvalidPerformer(piname, wsname, perfs, availFor, emailAddress, recipientLocale);
    }

    public boolean sendInvalidPerformer(String piname, String wsname, Vector performers, boolean availFor, String emailAddress, Locale recipientLocale) {
        boolean isSuccessful = false;
        if (emailAddress == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{performers});
        } else {
            String subject = this.getSubjectForInvalidPerformer(performers, availFor, recipientLocale);
            String content = this.getMessageForInvalidPerformer(piname, wsname, performers, recipientLocale);
            EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{emailAddress});
            try {
                isSuccessful = this.notify("EmailComposer.sendInvalidPerformer(S, S, V, b, S)", emsg);
            }
            catch (BizLogicException e) {
                if (!BLUtil.self().ignoreEmailErrors) {
                    throw e;
                }
                this.logError(e, "EmailComposer.sendInvalidPerformer()");
            }
            catch (Throwable ex) {
                if (!BLUtil.self().ignoreEmailErrors) {
                    throw new BizLogicException("BizLogic_ERR_3565", "EmailComposer.sendInvalidPerformer()", ex);
                }
                this.logError(ex, "EmailComposer.sendInvalidPerformer()");
            }
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{emailAddress, subject, "EmailComposer:sendInvalidPerformer(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean sendAvailChangeToAssign(WFProcessContext pCtx, long wiid, String performerEmail, Locale recipientLocale, String performerId, String performerAvailable) {
        boolean isSuccessful = false;
        if (performerEmail == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{performerAvailable});
        } else {
            WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
            String wiName = wieb.getName();
            String subject = this.getSubjectForAvailChangeToAssign(wiName, performerId, recipientLocale);
            String content = this.getMessageForAvailChangeToAssign(wiName, performerId, performerAvailable, recipientLocale);
            EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{performerEmail});
            try {
                isSuccessful = this.notify("EmailComposer.sendAvailChangeToAssign()", emsg);
            }
            catch (BizLogicException e) {
                if (!BLUtil.self().ignoreEmailErrors) {
                    throw e;
                }
                this.logError(e, "EmailComposer.sendAvailChangeToAssign()");
            }
            catch (Throwable ex) {
                if (!BLUtil.self().ignoreEmailErrors) {
                    throw new BizLogicException("BizLogic_ERR_3565", "EmailComposer.sendAvailChangeToAssign()", ex);
                }
                this.logError(ex, "EmailComposer.sendAvailChangeToAssign()");
            }
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{performerEmail, subject, "EmailComposer:sendAvailChangeToAssign(..)"});
            }
        }
        return isSuccessful;
    }

    public boolean notifyTaskCompleted(String winame, String performerId, String replyto, Locale recipientLocale) {
        if (!BLUtil.self().isSendEmailForTask()) {
            return false;
        }
        boolean isSuccessful = false;
        if (replyto == null) {
            BLControl.logger.warnKey("BizLogic_ERR_588", new Object[]{performerId});
            isSuccessful = false;
        } else {
            String subject = this.getSubjectForNotifyTaskCompleted(winame, recipientLocale);
            String content = this.getMessageForNotifyTaskCompleted(winame, performerId, recipientLocale);
            EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{replyto});
            isSuccessful = this.notify("EmailComposer.notifyTaskCompleted()", emsg);
            if (BLControl.util.DEBUG_ENGINE && isSuccessful) {
                BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{replyto, subject, "EmailComposer:sendAvailChangeToAssign(..)"});
            }
        }
        return isSuccessful;
    }

    private String getSubjectForAvailChangeToAssign(String taskName, String performerId, Locale recipientLocale) {
        MessageFactory messageFactory = this.getBLEmailMessageFactory(recipientLocale);
        Object[] objectArray = new Object[3];
        objectArray[0] = taskName;
        BLConstants.single();
        objectArray[1] = "assigned";
        objectArray[2] = performerId;
        return messageFactory.lookup("BLEMAIL_MSG_001", objectArray, false);
    }

    private String getSubjectForTaskDue(String taskName) {
        return this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_002", new Object[]{taskName}, false);
    }

    private String getMessageForTaskDue(String taskName, String performerId, boolean isPerformer) {
        if (isPerformer) {
            return this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_011", new Object[]{performerId, taskName}, false);
        }
        return this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_012", new Object[]{taskName, performerId}, false);
    }

    private String getMessageForAvailChangeToAssign(String taskName, String performerId, String performerAvailable, Locale recipientLocale) {
        return this.getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_013", new Object[]{performerAvailable, taskName, performerId}, false);
    }

    private String getSubjectForEPProblem(String workstepName, String piName) {
        return this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_003", new Object[]{workstepName, piName}, false);
    }

    private String getSubjectForMgrProblem(String manager) {
        return this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_004", new Object[]{manager}, false);
    }

    private String getSubjectForInvalidPerformer(Vector performers, boolean availFor, Locale recipientLocale) {
        if (performers.size() == 1) {
            String perf = (String)performers.get(0);
            return this.getSubjectForInvalidPerformer(perf, availFor, recipientLocale);
        }
        if (availFor) {
            return this.getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_007", null, false);
        }
        return this.getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_008", null, false);
    }

    private String getSubjectForInvalidPerformer(String performer, boolean availFor, Locale recipientLocale) {
        if (availFor) {
            return this.getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_005", new Object[]{performer}, false);
        }
        return this.getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_006", new Object[]{performer}, false);
    }

    private String getMessageForEPProblem(String piName, String workstepName, String adapterPerformer, String stackTrace) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_014", new Object[]{piName, workstepName, adapterPerformer}, false));
        if (stackTrace != null) {
            sb.append(this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_015", new Object[]{stackTrace}, false));
        }
        return sb.toString();
    }

    private String getMessageForMgrProblem(String ptname, String winame, String manager) {
        return this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_016", new Object[]{manager, ptname, winame}, false);
    }

    private String getMessageForInvalidPerformer(String piname, String wsname, String winame, String performer, Locale recipientLocale) {
        return this.getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_017", new Object[]{performer, piname, wsname, winame}, false);
    }

    private String getMessageForInvalidPerformer(String piname, String wsname, Vector performers, Locale recipientLocale) {
        if (performers.size() == 1) {
            String perf = (String)performers.get(0);
            return this.getMessageForInvalidPerformer(piname, wsname, perf, recipientLocale);
        }
        return this.getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_018", new Object[]{performers.toString(), piname, wsname}, false);
    }

    private String getMessageForInvalidPerformer(String piname, String wsname, String performer, Locale recipientLocale) {
        return this.getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_019", new Object[]{performer, piname, wsname}, false);
    }

    private String getSubjectForWorkitemSubprocessCompleted(String wiName) {
        return this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_009", new Object[]{wiName}, false);
    }

    private String getSubjectForNotifyTaskCompleted(String wiName, Locale recipientLocale) {
        return this.getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_010", new Object[]{wiName}, false);
    }

    private String getMessageForWorkitemSubprocessCompleted(String wiName, String spname, String creator, String outputs) {
        return this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_020", new Object[]{creator, spname, wiName, outputs}, false);
    }

    private String getMessageForNotifyTaskCompleted(String wiName, String creator, Locale recipientLocale) {
        return this.getBLEmailMessageFactory(recipientLocale).lookup("BLEMAIL_MSG_021", new Object[]{creator, wiName}, false);
    }

    public void sendEmailWithBizSoloURLOnly(WFProcessContext pCtx, long wiid, String performer) {
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        String wiName = wieb.getName();
        String webappURL = "";
        try {
            webappURL = this.getWebAppURL(pCtx, wiid);
        }
        catch (BizLogicException ex) {
            if (!BLUtil.self().ignoreEmailErrors) {
                throw ex;
            }
            BLControl.logger.errorKey("BizLogic_ERR_4713", "EmailComposer.sendEmailWithBizSoloURLOnly()", (Throwable)ex, new Object[0]);
        }
        catch (Throwable th) {
            if (!BLUtil.self().ignoreEmailErrors) {
                throw new BizLogicException("BizLogic_ERR_4713", "EmailComposer.sendEmailWithBizSoloURLOnly()", th);
            }
            BLControl.logger.errorKey("BizLogic_ERR_4713", "EmailComposer.sendEmailWithBizSoloURLOnly()", th, new Object[0]);
        }
        String subject = this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_022", new Object[]{wiName}, false);
        String content = this.getBLEmailMessageFactory(null).lookup("BLEMAIL_MSG_023", new Object[]{performer, wiName, webappURL}, false);
        EmailMessage emsg = new EmailMessage(subject, content, null, new String[]{BLUtil.BLEMAILACCOUNT}, new String[]{performer});
        Notify.self().send((BLMessage)emsg);
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_932", new Object[]{BLUtil.BLEMAILACCOUNT, subject, "EmailComposer:sendEmailWithBizSoloURLOnly(..)"});
        }
    }

    private String getWebAppURL(WFProcessContext pCtx, long wiid) throws UnsupportedEncodingException {
        this.readProperties();
        StringBuilder urlBuffer = new StringBuilder(this.serverURL);
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        String wiName = wieb.getName();
        long wsid = wieb.getWorkStepID();
        WFAtomicWS ws = (WFAtomicWS)pCtx.getWorkstep(wsid);
        if (WFAtomicInstance.self().isWorkstepWebApp(pCtx, ws)) {
            if (ws.isPerformingAppPrivate()) {
                if (!this.serverURL.endsWith("/") && !this.servletRoot.startsWith("/")) {
                    urlBuffer.append("/");
                }
                urlBuffer.append(this.servletRoot);
                if (!this.servletRoot.endsWith("/")) {
                    urlBuffer.append("/");
                }
                urlBuffer.append(pCtx.getProcessTemplateName()).append("/");
                BLConstants.PerfAppConstants cfr_ignored_0 = BLControl.consts.perfApp;
                urlBuffer.append("WEBAPP".toLowerCase());
                urlBuffer.append("/");
            } else {
                if (!this.serverURL.endsWith("/") && !this.bizsoloServletRoot.startsWith("/")) {
                    urlBuffer.append("/");
                }
                urlBuffer.append(this.bizsoloServletRoot);
                if (!this.bizsoloServletRoot.endsWith("/")) {
                    urlBuffer.append("/");
                }
            }
            Object performingObj = pCtx.getWorkstepRealPerformingApp(wsid);
            String performingApp = "";
            if (performingObj != null) {
                performingApp = performingObj.toString();
            }
            urlBuffer.append(performingApp);
            urlBuffer.append("/Start.jsp?");
            Session session = pCtx.getSession();
            if (session != null) {
                urlBuffer.append("&bizsite_user=");
                urlBuffer.append(URLHexCoder.encode((String)session.getUser()));
            }
            urlBuffer.append("&workitemName=");
            urlBuffer.append(URLHexCoder.encode((String)wiName));
        } else {
            if (!this.serverURL.endsWith("/") && !this.servletRoot.startsWith("/")) {
                urlBuffer.append("/");
            }
            urlBuffer.append(this.servletRoot);
            if (!this.servletRoot.endsWith("/")) {
                urlBuffer.append("/");
            }
            urlBuffer.append("BLPT?taskName=");
            urlBuffer.append(URLHexCoder.encode((String)wiName));
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.info((Object)("URL for task " + wiName + " is: " + urlBuffer.toString()));
        }
        return urlBuffer.toString();
    }

    private void readProperties() {
        if (this.returnPage != null && this.servletRoot != null && this.bizsoloServletRoot != null && this.serverURL != null) {
            return;
        }
        this.returnPage = "";
        this.servletRoot = "";
        this.bizsoloServletRoot = "";
        this.serverURL = SBMControl.util.getWebHost();
        String propString = "";
        try {
            Properties prop = ResourceUtil.getPropertyObject((String)(SBMControl.util.ABSOLUTE_CONF_PATH + "bizsolo.conf"));
            Properties sbmprop = ResourceUtil.getPropertyObject((String)(SBMControl.util.ABSOLUTE_CONF_PATH + "sbm.conf"));
            propString = prop.getProperty("returnPage", "");
            if (SBMUtil.isValidProperty((String)propString)) {
                this.returnPage = propString;
            }
            propString = sbmprop.getProperty("sbm.servletRoot", "");
            if (SBMUtil.isValidProperty((String)propString)) {
                this.servletRoot = propString;
            }
            propString = prop.getProperty("bizsolo.http.alias", "");
            if (SBMUtil.isValidProperty((String)propString)) {
                this.bizsoloServletRoot = propString;
            }
        }
        catch (BizLogicException ex) {
            if (!BLUtil.self().ignoreEmailErrors) {
                throw ex;
            }
            BLControl.logger.errorKey("BizLogic_ERR_4714", "EmailComposer.readProperties()", (Throwable)ex, new Object[0]);
        }
        catch (Throwable th) {
            if (!BLUtil.self().ignoreEmailErrors) {
                throw new BizLogicException("BizLogic_ERR_4714", "EmailComposer.readProperties()", th);
            }
            BLControl.logger.errorKey("BizLogic_ERR_4714", "EmailComposer.readProperties()", th, new Object[0]);
        }
    }

    private boolean notify(String context, EmailMessage emsg) {
        try {
            return Notify.self().send((BLMessage)emsg);
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_3565", "EmailComposer.notify()", th);
        }
    }

    private MessageFactory createEmailMessageFactory(Locale locale) {
        MessageFactory blEmailMsgFactory = null;
        try {
            blEmailMsgFactory = MessageFactory.getInstance((String)"resources.i18n.bizlogic.bizlogicemail", (ClassLoader)EmailComposer.class.getClassLoader(), (Locale)locale);
            if (blEmailMsgFactory != null) {
                blEmailMsgFactory.setMessageSuffix("");
            }
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_4712", "EmailComposer.createEmailMessageFactory()", th);
        }
        return blEmailMsgFactory;
    }

    private void logError(Throwable th, String context) {
        BLControl.logger.errorKey("BizLogic_ERR_3565", context, th, new Object[0]);
    }

    public MessageFactory getBLEmailMessageFactory() {
        return this.getBLEmailMessageFactory(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageFactory getBLEmailMessageFactory(Locale recipientLocale) {
        MessageFactory blEmailMsgFactory;
        if (recipientLocale == null) {
            recipientLocale = Locale.getDefault();
        }
        if ((blEmailMsgFactory = this.blEmailMsgFactories.get(recipientLocale)) == null) {
            EmailComposer emailComposer = this;
            synchronized (emailComposer) {
                if (blEmailMsgFactory == null) {
                    blEmailMsgFactory = this.createEmailMessageFactory(recipientLocale);
                    this.blEmailMsgFactories.put(recipientLocale, blEmailMsgFactory);
                }
            }
        }
        return blEmailMsgFactory;
    }
}

