/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.ejb.bizlogic.manager;

import com.savvion.ejb.bizlogic.manager.BLMigrationUtil;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.svo.AbstractDataSlot;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.server.svo.DataSlotTemplate;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.ProcessCountList;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplateList;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.server.svo.WorkItemList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstance;
import com.savvion.sbm.bizlogic.server.svo.WorkStepTemplate;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.bizlogic.util.SessionAdapter;
import com.savvion.sbm.bizlogic.util.SessionManager;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMUtil;
import com.tdiinc.BizLogic.Server.PAKClientData;
import com.tdiinc.BizLogic.Server.PAKClientWorkitem;
import com.tdiinc.BizLogic.Server.PAKException;
import com.tdiinc.BizLogic.Server.PAKExceptionServer;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.EJBException;

public class BizLogicManagerBean
extends SessionAdapter {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String PIPREFIX = "PIPREFIX";
    final String NOT_SUPPORTED = "This method is not supported in BizLogic 4.0";

    public void start(String user, String password) {
        try {
            BLServer blServer = BLMigrationUtil.getBLServer();
            blServer.start(user, password);
            Session ses = blServer.connect(user, password);
            BLMigrationUtil.setIsClustering(blServer.isClustering(ses));
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public Hashtable getBizLogicServerStatus() {
        try {
            BLServer blServer = BLMigrationUtil.getBLServer();
            Session ses = blServer.connect(SBMControl.util.getGuestUser(), SBMControl.util.getGuestPasswd());
            Hashtable serverStatus = new Hashtable(blServer.getInfo(ses));
            blServer.disConnect(ses);
            return serverStatus;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getBizLogicVersion(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getVersion(ses);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getStartTime(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return SBMUtil.self().getFormattedDate(blServer.getStartTime(ses).getTime());
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public int getStatus() {
        try {
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getServerState();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return -1;
        }
    }

    public void reloadBizLogicConfiguration(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            blServer.refresh(ses);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void removeAllProcesses(String session) {
        new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void resumeBizLogicServer(String userID, String password) {
        try {
            BLServer blServer = BLMigrationUtil.getBLServer();
            blServer.resume(userID, password);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setTimerInterval(String session, String sec) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            int minutes = Integer.parseInt(sec) / 60;
            blServer.setTimerSchedule(ses, minutes);
        }
        catch (NumberFormatException ses) {
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void shutdown(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            blServer.shutdown(ses);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void suspendBizLogicServer(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            blServer.suspend(ses);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public String connect(String userID, String password) {
        try {
            BLServer blServer = BLMigrationUtil.getBLServer();
            Session session = blServer.connect(userID, password);
            return String.valueOf(session.getID());
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public void disconnect(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            blServer.disConnect(ses);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public String[] getActiveSessionList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector sesCache = blServer.getSessionList(ses);
            Vector<String> sesList = new Vector<String>();
            for (int ix = sesCache.size() - 1; ix >= 0; --ix) {
                Session s = (Session)sesCache.elementAt(ix);
                sesList.addElement("Session : " + s.getID() + " from : " + s.getUser() + " started : " + s.getStartTime());
            }
            BLUtil.self();
            return BLUtil.Vector2String(sesList);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public int getSessionCount(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getSessionCount(ses);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return 0;
        }
    }

    public boolean isSessionValid(String session) {
        boolean valid = false;
        try {
            Session ses = BLMigrationUtil.getSession(session);
            SessionManager.validate((Session)ses, (String)"isValidSession");
            valid = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    public void setSessionTimeout(String session, long sec) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            blServer.setSessionTimeOut(ses, sec / 60L);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public String getManager(String session, String pName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getProcess(ses, pName).getManager();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public void setManager(String session, String pName, String mgrName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcess(ses, pName);
            pt.setManager(mgrName);
            pt.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setProcessInstanceCreator(String session, String piName, String creator) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            pi.setCreator(creator);
            pi.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setProcessInstancePriority(String session, String piName, String priority) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            pi.setPriority(priority);
            pi.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public String getDataslotChoice(String session, String pName, String dsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            AbstractDataSlot ds = null;
            ds = BLMigrationUtil.isProcessInstance(pName) ? blServer.getDataSlot(ses, pName, dsName) : blServer.getDataSlotTemplate(ses, pName, dsName);
            return BLMigrationUtil.getDataslotChoicesAsString(ds.getChoices());
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getDataslotInfo(String session, String pName, boolean isPublicOnly) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector<Hashtable> dsInfos = new Vector<Hashtable>();
            Vector dsList = null;
            if (BLMigrationUtil.isProcessInstance(pName)) {
                ProcessInstance pi = blServer.getProcessInstance(ses, pName);
                dsList = pi.getDataSlotList((boolean)false, (boolean)isPublicOnly).list;
            } else {
                ProcessTemplate pt = blServer.getProcessTemplate(ses, pName);
                dsList = pt.getDataSlotTemplateList();
            }
            AbstractDataSlot ds = null;
            HashMap info = null;
            for (int ix = dsList.size() - 1; ix >= 0; --ix) {
                ds = (AbstractDataSlot)dsList.get(ix);
                info = ds.getMetaData();
                BLConstants.single();
                info.put("DATASLOTNAME", ds.getName());
                BLConstants.single();
                info.put("DATASLOTVALUE", ds.getValue());
                BLUtil.self();
                dsInfos.addElement(BLUtil.convertToHashtable((HashMap)info));
            }
            return dsInfos;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getDataslotInfo(String session, String pName) {
        return this.getDataslotInfo(session, pName, true);
    }

    public Hashtable getDataslotInfo(String session, String pName, String dsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            AbstractDataSlot ds = null;
            if (BLMigrationUtil.isProcessInstance(pName)) {
                ProcessInstance pi = blServer.getProcessInstance(ses, pName);
                ds = pi.getDataSlot(dsName);
            } else {
                ProcessTemplate pt = blServer.getProcessTemplate(ses, pName);
                ds = pt.getDataSlotTemplate(dsName);
            }
            HashMap dsInfos = ds.getMetaData();
            BLConstants.single();
            dsInfos.put("DATASLOTNAME", ds.getName());
            BLConstants.single();
            dsInfos.put("DATASLOTVALUE", ds.getValue());
            BLUtil.self();
            return BLUtil.convertToHashtable((HashMap)dsInfos);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Object getDataslotValue(String session, String piName, String dsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            DataSlot ds = blServer.getDataSlot(ses, piName, dsName);
            return ds.getValue();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String[] getInputDataslotNames(String session, String pName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcess(ses, pName);
            WorkStepTemplate ws = pt.getWorkStepTemplate(wsName);
            HashMap mappedNames = ws.getInputDataSlotNames();
            String[] inputDSNames = new String[mappedNames.size()];
            int index = 0;
            for (String actualName : mappedNames.keySet()) {
                String mappedName;
                if (actualName.equals(mappedName = (String)mappedNames.get(actualName))) {
                    inputDSNames[index++] = actualName;
                    continue;
                }
                int n = index++;
                StringBuilder stringBuilder = new StringBuilder().append(actualName);
                BLConstants.single();
                inputDSNames[n] = stringBuilder.append("@").append(mappedName).toString();
            }
            return inputDSNames;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String[] getOutputDataslotNames(String session, String pName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcess(ses, pName);
            WorkStepTemplate ws = pt.getWorkStepTemplate(wsName);
            HashMap mappedNames = ws.getOutputDataSlotNames();
            String[] outputDSNames = new String[mappedNames.size()];
            int index = 0;
            for (String actualName : mappedNames.keySet()) {
                String mappedName;
                if (actualName.equals(mappedName = (String)mappedNames.get(actualName))) {
                    outputDSNames[index++] = actualName;
                    continue;
                }
                int n = index++;
                StringBuilder stringBuilder = new StringBuilder().append(actualName);
                BLConstants.single();
                outputDSNames[n] = stringBuilder.append("@").append(mappedName).toString();
            }
            return outputDSNames;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public void setDataslotChoice(String session, String ptName, String dsName, String choice) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            DataSlotTemplate ds = blServer.getDataSlotTemplate(ses, ptName, dsName);
            Vector<String> choiceList = null;
            if (choice != null) {
                choiceList = new Vector<String>();
                StringTokenizer tok = new StringTokenizer(choice, "|,");
                while (tok.hasMoreTokens()) {
                    choiceList.addElement(tok.nextToken());
                }
            }
            ds.setChoices(choiceList);
            ds.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setDataslotValue(String session, String pName, String dsName, Object data) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            AbstractDataSlot ds = null;
            if (BLMigrationUtil.isProcessInstance(pName)) {
                ProcessInstance pi = blServer.getProcessInstance(ses, pName);
                ds = pi.getDataSlot(dsName);
            } else {
                ProcessTemplate pt = blServer.getProcessTemplate(ses, pName);
                ds = pt.getDataSlotTemplate(dsName);
            }
            ds.setValue(data);
            ds.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setDataslotValue(String session, String pName, String dsName, String data) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            AbstractDataSlot ds = null;
            if (BLMigrationUtil.isProcessInstance(pName)) {
                ProcessInstance pi = blServer.getProcessInstance(ses, pName);
                ds = pi.getDataSlot(dsName);
            } else {
                ProcessTemplate pt = blServer.getProcessTemplate(ses, pName);
                ds = pt.getDataSlotTemplate(dsName);
            }
            if (ds.isDateTime()) {
                ds.setValue(new DateTime(SBMUtil.self().getDateTime(data, false)));
            } else if (ds.isDecimal()) {
                ds.setValue(new Decimal(data));
            } else if (ds.isXML()) {
                ds.setValue(new XML(data));
            } else if (ds.isDocument()) {
                DocumentDS value = (DocumentDS)ds.getValue();
                if (!FileUtil.isValidURL((String)data)) {
                    data = FileUtil.getFileURL((String)data);
                }
                URL url = new URL(data);
                value.create(ses.getUser(), BLUtil.getDocumentName((URL)url), url, null);
                ds.setValue(value);
            } else {
                ds.setValue(data);
            }
            ds.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public String createAndInstallProcessTemplate(String session, String xmlFileName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.createProcessTemplate(ses, xmlFileName, true);
            return pt.getName();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String createAndInstallProcessTemplateVersion(String session, String xmlFileName, String parentPTName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate parentPT = blServer.getProcessTemplate(ses, parentPTName);
            ProcessTemplate ptSVO = parentPT.createVersion(xmlFileName);
            return ptSVO.getName();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String createProcessTemplate(String session, String xmlFileName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.createProcessTemplate(ses, xmlFileName, false);
            return pt.getName();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getProcessList(String session) {
        try {
            Vector PIList;
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            String CPT = "Created_Process_Template";
            String IPT = "Installed_Process_Template";
            String SPT = "Suspended_Process_Template";
            String RPT = "Removed_Process_Template";
            String CPI = "Created_Process_Instance";
            String API = "Active_Process_Instance";
            String SPI = "Suspended_Process_Instance";
            Hashtable h = new Hashtable();
            Vector PTList = blServer.getProcessTemplateList((Session)ses).list;
            int ix = 0;
            if (PTList != null) {
                for (ix = PTList.size() - 1; ix >= 0; --ix) {
                    ProcessTemplate pt = (ProcessTemplate)PTList.elementAt(ix);
                    Vector<String> v = new Vector<String>();
                    int n = pt.getState();
                    BLConstants.single();
                    if (n == 1) {
                        v.addElement(CPT);
                    } else {
                        int n2 = pt.getState();
                        BLConstants.single();
                        if (n2 == 2) {
                            v.addElement(IPT);
                        } else {
                            int n3 = pt.getState();
                            BLConstants.single();
                            if (n3 == 4) {
                                v.addElement(SPT);
                            }
                        }
                    }
                    h.put(pt.getName(), v);
                }
            }
            if ((PIList = blServer.getProcessInstanceList((Session)ses).list) != null) {
                for (ix = PIList.size() - 1; ix >= 0; --ix) {
                    HashMap attrs = ((ProcessInstance)PIList.elementAt(ix)).getAttributes();
                    BLConstants.single();
                    long ptid = (Long)attrs.get("PROCESSTEMPLATEID");
                    String ptName = blServer.getProcessTemplate(ses, ptid).getName();
                    Vector<String> v = (Vector<String>)h.get(ptName);
                    if (v == null) {
                        v = new Vector<String>();
                        h.put(ptName, v);
                        v.addElement(RPT);
                    }
                    BLConstants.single();
                    int status = (Integer)attrs.get("STATUS");
                    BLConstants.single();
                    String piName = (String)attrs.get("PROCESSINSTANCENAME");
                    BLConstants.single();
                    if (status == 6) {
                        v.addElement(piName);
                        v.addElement(CPI);
                        continue;
                    }
                    BLConstants.single();
                    if (status == 8) {
                        v.addElement(piName);
                        v.addElement(SPI);
                        continue;
                    }
                    v.addElement(piName);
                    v.addElement(API);
                }
            }
            return h;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getProcessTemplateDisplayName(String session, String ptName) {
        return this.getDisplayName(session, ptName);
    }

    public Vector getProcessTemplateFYI(String session, String pName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcess(ses, pName);
            return pt.getFYI();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public long getProcessTemplateID(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getProcessTemplate(ses, ptName).getID();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return -1L;
        }
    }

    public Hashtable getProcessTemplateInfo(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptName);
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            if (pt.getCategory() != null) {
                info.put("CATEGORY", pt.getCategory());
            }
            if (pt.getGroup() != null) {
                info.put("GROUP", pt.getGroup());
            }
            if (pt.getDescription() != null) {
                info.put("DESCRIPTION", pt.getDescription());
            }
            if (pt.getInfo() != null) {
                info.put("INFO", pt.getInfo());
            }
            if (pt.getFYI() != null) {
                info.put("FYI", pt.getFYI());
            }
            if (pt.getDisplayName() != null) {
                info.put("APP_NAME", pt.getDisplayName());
            }
            return info;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String[] getProcessTemplateList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector ptList = blServer.getProcessTemplateList((Session)ses).list;
            String[] ptNames = new String[ptList.size()];
            int ix = 0;
            Iterator iter = ptList.iterator();
            while (iter.hasNext()) {
                ptNames[ix++] = ((ProcessTemplate)iter.next()).getName();
            }
            return ptNames;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getProcessTemplateListWithComments(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector ptList = blServer.getActivatedProcessTemplateList((Session)ses).list;
            Hashtable<String, String> ht = new Hashtable<String, String>();
            for (ProcessTemplate pt : ptList) {
                if (pt.getDescription() == null) {
                    ht.put(pt.getName(), "");
                    continue;
                }
                ht.put(pt.getName(), pt.getDescription());
            }
            return ht;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getProcessTemplateName(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcess(ses, piName);
            return pt.getName();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getProcessTemplateName(String session, long ptID) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getProcessTemplate(ses, ptID).getName();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getProcessTemplateVersions(String session, String displayName) {
        try {
            if (displayName == null || displayName.trim().equals("")) {
                PAKExceptionServer.throwPAKException("BizLogic_ERR_1583", displayName);
            }
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector ptList = blServer.getProcessTemplateVersions((Session)ses, (String)displayName).list;
            Hashtable<String, String> tempList = new Hashtable<String, String>();
            ProcessTemplate pt2 = null;
            String state = null;
            for (ProcessTemplate pt2 : ptList) {
                if (!pt2.getDisplayName().equals(displayName)) continue;
                int status = pt2.getState();
                BLConstants.single();
                if (status == 1) {
                    state = "CREATED";
                } else {
                    BLConstants.single();
                    if (status == 2) {
                        state = "INSTALLED";
                    } else {
                        BLConstants.single();
                        if (status == 4) {
                            state = "SUSPENDED";
                        }
                    }
                }
                tempList.put(pt2.getName(), state);
            }
            return tempList;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public PAKClientWorkitem getProcessTemplateWorkitem(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            HashMap hm = blServer.getProcessTemplateStartWorkStepData(ses, ptName);
            BLConstants.single();
            String wsname = (String)hm.get("WORKSTEPNAME");
            BLConstants.single();
            Long ptid = (Long)hm.get("PROCESSTEMPLATEID");
            BLConstants.single();
            PAKClientData[] pcd = BLMigrationUtil.getClientData(session, ptName, (Vector)hm.get("OUTPUTDATASLOTS"), wsname);
            BLConstants.single();
            String string = (String)hm.get("PERFORMINGAPP");
            BLConstants.single();
            String string2 = (String)hm.get("INSTRUCTION");
            BLConstants.single();
            PAKClientWorkitem cw = new PAKClientWorkitem(-1L, -1L, ptName, wsname, pcd, string, string2, (String)hm.get("PRIORITY"));
            BLConstants.single();
            cw.setProcessDisplayName((String)hm.get("APP_NAME"));
            cw.setTemplateId(ptid);
            return cw;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getProcessTemplateWorkstepInfo(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptName);
            Vector wsList = pt.getWorkStepTemplateList();
            Vector v = new Vector();
            for (int x = 0; x < wsList.size(); ++x) {
                WorkStepTemplate ws = (WorkStepTemplate)wsList.elementAt(x);
                Hashtable<String, Object> h = new Hashtable<String, Object>();
                if (ws.getName() != null) {
                    BLConstants.single();
                    h.put("WORKSTEPNAME", ws.getName());
                } else {
                    BLConstants.single();
                    BLConstants.single();
                    h.put("WORKSTEPNAME", "");
                }
                BLConstants.single();
                h.put("TYPE", ws.getTypeString());
                int status = ws.getState();
                BLConstants.single();
                h.put("STATUS", BLMigrationUtil.getEventMessage(status, null));
                String wsperformer = ws.getPerformer();
                if (wsperformer != null) {
                    BLConstants.single();
                    h.put("PERFORMER", wsperformer);
                } else {
                    BLConstants.single();
                    BLConstants.single();
                    h.put("PERFORMER", "");
                }
                BLConstants.single();
                h.put("DURATION", ws.getDuration());
                v.addElement(h);
            }
            return v;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getProcessTemplateXML(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getProcessTemplate(ses, ptName).getXML();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String[] getSuspendedProcessTemplateList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector ptList = blServer.getSuspendedProcessTemplateList((Session)ses).list;
            String[] ptNames = new String[ptList.size()];
            int ix = 0;
            Iterator iter = ptList.iterator();
            while (iter.hasNext()) {
                ptNames[ix++] = ((ProcessTemplate)iter.next()).getName();
            }
            return ptNames;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getUserAuthorizedProcessTemplateList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Hashtable<String, String> userPTList = new Hashtable<String, String>();
            Vector ptList = blServer.getUserAuthorizedProcessTemplateList((Session)ses).list;
            for (ProcessTemplate pt : ptList) {
                if (!pt.isActivated()) continue;
                if (pt.getDescription() == null) {
                    userPTList.put(pt.getName(), "");
                    continue;
                }
                userPTList.put(pt.getName(), pt.getDescription());
            }
            return userPTList;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getUserProcessTemplateList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector ptList = blServer.getUserProcessTemplateList((Session)ses).list;
            Hashtable userPTList = new Hashtable();
            for (ProcessTemplate pt : ptList) {
                if (!pt.isActivated()) continue;
                Vector<String> ptInfo = new Vector<String>();
                ptInfo.addElement(pt.getName());
                ptInfo.addElement(pt.getDisplayName());
                ptInfo.addElement(pt.getDescription());
                long ProcessTemplateID = pt.getID();
                userPTList.put(ProcessTemplateID, ptInfo);
            }
            return userPTList;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public void installProcessTemplate(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptName);
            pt.activate();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public boolean isProcessTemplateCreated(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            try {
                BLServer blServer = BLMigrationUtil.getBLServer();
                blServer.getProcessTemplate(ses, ptName);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        catch (BizLogicException e) {
            PAKExceptionServer.throwPAKException(e);
            return false;
        }
    }

    public boolean isValidProcessTemplate(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.isProcessTemplateExist(ses, ptName);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return false;
        }
    }

    public void removeProcessTemplate(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptName);
            pt.remove();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void resumeProcessTemplate(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptName);
            pt.resume();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setProcessDataslotValues(String session, String pName, Hashtable dsValues) {
        try {
            if (dsValues == null || dsValues.isEmpty()) {
                return;
            }
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            if (BLMigrationUtil.isProcessInstance(pName)) {
                ProcessInstance pi = blServer.getProcessInstance(ses, pName);
                pi.updateSlotValue(new HashMap(dsValues));
            } else {
                ProcessTemplate pt = blServer.getProcessTemplate(ses, pName);
                DataSlotTemplate ds = null;
                String dsName = null;
                Enumeration enumeration = dsValues.keys();
                while (enumeration.hasMoreElements()) {
                    dsName = (String)enumeration.nextElement();
                    Object data = dsValues.get(dsName);
                    ds = pt.getDataSlotTemplate(dsName);
                    ds.setValue(data);
                    ds.save();
                }
            }
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setProcessDescription(String session, String pName, String description) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcess(ses, pName);
            pt.setDescription(description);
            pt.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setProcessTemplateDisplayName(String session, String ptName, String displayName) {
        this.setDisplayName(session, ptName, displayName);
    }

    public void setProcessTemplateFYI(String session, String ptName, Vector fyi) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptName);
            pt.setFYI(fyi);
            pt.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setProcessTemplateWorkstepFYI(String session, String ptName, String wsName, Vector fyi) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate ws = blServer.getWorkStepTemplate(ses, ptName, wsName);
            ws.setFYI(fyi);
            ws.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void suspendProcessTemplate(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptName);
            pt.suspend();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void activateProcessInstance(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            pi.activate();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public String createProcessInstance(String session, String piName, PAKClientWorkitem wiObject) {
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        PAKClientData[] cd = wiObject.getAttachedData();
        for (int x = 0; x < cd.length; ++x) {
            if (cd[x].isReadOnly()) continue;
            dsValues.put(cd[x].getName(), cd[x].getValue());
        }
        return this.createProcessInstance(session, wiObject.getPTname(), piName, wiObject.getPriority(), dsValues);
    }

    public String createProcessInstance(String session, String ptName, String piName, String priority) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptName);
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            BLConstants.single();
            attrs.put("PROCESSTEMPLATEID", pt.getID());
            BLConstants.single();
            attrs.put("PROCESSINSTANCENAME", piName);
            BLConstants.single();
            attrs.put("PRIORITY", priority);
            ProcessInstance pi = blServer.createProcessInstance(ses, ptName, attrs, null, false);
            if (pi != null) {
                return pi.getName();
            }
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
        return null;
    }

    public String createProcessInstance(String session, String ptName, String piName, String priority, Hashtable dsValues) {
        HashMap values = null;
        if (dsValues != null && !dsValues.isEmpty()) {
            values = new HashMap(dsValues);
        }
        return this.createProcessInstance(session, ptName, piName, priority, values);
    }

    private String createProcessInstance(String session, String ptName, String piName, String priority, HashMap dsValues) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            HashMap<String, String> attrs = new HashMap<String, String>();
            BLConstants.single();
            attrs.put("PROCESSINSTANCENAME", piName);
            BLConstants.single();
            attrs.put("PRIORITY", priority);
            ProcessInstance pi = blServer.createProcessInstance(ses, ptName, attrs, dsValues, true);
            if (pi != null) {
                return pi.getName();
            }
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
        return null;
    }

    public String[] getProcessInstanceActiveWorkstepList(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            return pi.getActivatedWorkStepNames();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getProcessInstanceCount(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            return this.getPICountInfo(ses, ses.getUser());
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getProcessInstanceCount(String session, String user) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            return this.getPICountInfo(ses, user);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public ProcessCountList getProcessCountList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getProcessCountList(ses, ses.getUser());
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getProcessInstanceDataslotInfo(String session, String piName) {
        return this.getDataslotInfo(session, piName);
    }

    public String getProcessInstanceDuedate(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            DateTime dueDate = pi.getDueDate();
            return SBMUtil.self().getFormattedDate(dueDate.getTime());
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getProcessInstanceInfo(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance processInstance = blServer.getProcessInstance(ses, piName);
            ProcessTemplate processTemplate = processInstance.getProcessTemplate();
            Map<String, Object> map = this.getProcessTemplateFieldMap(piName, processInstance, processTemplate);
            return new Hashtable<String, Object>(map);
        }
        catch (RuntimeException | RemoteException e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    private Map<String, Object> getProcessTemplateFieldMap(String piName, ProcessInstance instance, ProcessTemplate template) throws RemoteException {
        String piPrefix;
        String creator;
        long timeStarted;
        HashMap<String, Object> map = new HashMap<String, Object>();
        long instanceID = instance.getID();
        if (template.getCategory() != null) {
            map.put("CATEGORY", template.getCategory());
        }
        if (template.getGroup() != null) {
            map.put("GROUP", template.getGroup());
        }
        if (template.getDescription() != null) {
            map.put("DESCRIPTION", template.getDescription());
        }
        if (instance.getPriority() != null) {
            map.put("PRIORITY", instance.getPriority());
        }
        if ((timeStarted = instance.getStartTime()) != 0L) {
            map.put("STARTTIME", new DateTime(timeStarted).getStringValue());
            map.put("STARTTIME_IN_LONG", instance.getAttributes().get("STARTTIME"));
        }
        if (template.getEstimatedDuration() != 0L) {
            map.put("ESTIMATEDDURATION", template.getAttributes().get("ESTIMATEDDURATION"));
        }
        if (template.getInfo() != null) {
            map.put("INFO", template.getInfo());
        }
        if ((creator = instance.getCreator()) != null) {
            map.put("CREATOR", creator);
        }
        if ((piPrefix = BLMigrationUtil.getPIPrefix(piName)) != null) {
            map.put(PIPREFIX, piPrefix);
        }
        map.put("PROCESSINSTANCEID", String.valueOf(instance.getID()));
        int status = instance.getState();
        map.put("STATUS", BLMigrationUtil.getEventMessage(status, null));
        map.put("TO-STRING", this.buildDetailedString(instance, instanceID, template).toString());
        return map;
    }

    private StringBuilder buildDetailedString(ProcessInstance pi, long piid, ProcessTemplate pt) throws RemoteException {
        StringBuilder builder = new StringBuilder().append(LINE_SEPARATOR + pi.getName() + " status report:" + LINE_SEPARATOR).append("Template    : " + pt.getName() + LINE_SEPARATOR);
        if (pi.getPriority() != null) {
            builder.append("Priority    : " + pi.getPriority() + LINE_SEPARATOR);
        }
        builder.append("Instance ID : " + piid + LINE_SEPARATOR);
        if (pi.getCreator() != null) {
            builder.append("Creator : " + pi.getCreator() + LINE_SEPARATOR);
        }
        builder.append("Started on  : " + new Date(pi.getStartTime()).toString() + LINE_SEPARATOR).append("Status is   : " + BLMigrationUtil.getEventMessage(pi.getState(), null) + LINE_SEPARATOR);
        Map<Long, WorkStepInstance> wsInstanceInfo = this.getWorkStepInstanceMap(pi);
        Map<Long, String> wiInfo = this.getWorkItemInfoMap(pi);
        Vector wsTemplateList = pi.getWorkStepTemplateList();
        builder.append(LINE_SEPARATOR + "            WORKSTEPS   : \n            ==============\n");
        if (wsTemplateList != null && wsTemplateList.size() != 0) {
            builder.append((CharSequence)this.buildEachTemplateInfo(wsInstanceInfo, wiInfo, wsTemplateList));
        }
        Vector dsList = pi.getDataSlotList().list;
        builder.append(LINE_SEPARATOR + "DATASLOTS:\n==========\n");
        for (DataSlot ds : dsList) {
            builder.append(ds.getName() + "  Type : " + ds.getType() + LINE_SEPARATOR);
            if (!ds.isPublic()) continue;
            if (ds.isObject() && ds.getValue() != null) {
                builder.append(" Value : instance of " + ds.getObjectType() + LINE_SEPARATOR);
                continue;
            }
            builder.append(" Value : " + ds.getValue() + LINE_SEPARATOR);
        }
        builder.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        return builder;
    }

    private Map<Long, WorkStepInstance> getWorkStepInstanceMap(ProcessInstance instance) throws RemoteException {
        HashMap<Long, WorkStepInstance> wsInstanceInfo = new HashMap<Long, WorkStepInstance>();
        Vector wsiList = instance.getWorkStepInstanceList().list;
        if (wsiList != null && !wsiList.isEmpty()) {
            for (WorkStepInstance wsi : wsiList) {
                wsInstanceInfo.put(wsi.getID(), wsi);
            }
        }
        return wsInstanceInfo;
    }

    private Map<Long, String> getWorkItemInfoMap(ProcessInstance pi) throws RemoteException {
        HashMap<Long, String> wiInfo = new HashMap<Long, String>();
        Vector wiList = pi.getWorkItemList().list;
        for (WorkItem wi : wiList) {
            String thisWIInfo = wi.getName() + "\t Assigned to: " + wi.getPerformer();
            long wsId = wi.getWorkStepID();
            String allWI = (String)wiInfo.get(wsId);
            wiInfo.put(wsId, allWI != null ? allWI + LINE_SEPARATOR + thisWIInfo : thisWIInfo);
        }
        return wiInfo;
    }

    private StringBuilder buildEachTemplateInfo(Map<Long, WorkStepInstance> wsInstanceInfo, Map<Long, String> wiInfo, List<WorkStepTemplate> wsTemplateList) throws RemoteException {
        StringBuilder builder = new StringBuilder();
        for (WorkStepTemplate ws : wsTemplateList) {
            long wsId = ws.getID();
            WorkStepInstance wsi = wsInstanceInfo.get(wsId);
            boolean isWsiFound = wsi != null;
            builder.append(LINE_SEPARATOR).append("  WORKSTEP    : " + ws.getName() + "  (" + ws.getTypeString() + ")\n").append("  STATUS      : " + (isWsiFound ? BLMigrationUtil.getEventMessage(wsi.getState(), null) : BLMigrationUtil.getEventMessage(15, null)) + LINE_SEPARATOR).append(BizLogicManagerBean.appendField(isWsiFound ? wsi.getPerformer() : ws.getPerformer(), "  performer   : ")).append(BizLogicManagerBean.appendField(isWsiFound ? wsi.getInstruction() : ws.getInstruction(), "  Instruction     : ")).append(BizLogicManagerBean.appendField(isWsiFound ? wsi.getPreCondition() : ws.getPreCondition(), "  Start Condition : "));
            if (wsi != null && wsi.getCompleteTime() > 0L) {
                builder.append("  Compeleted on   : " + new Date(wsi.getCompleteTime()).toString() + LINE_SEPARATOR);
            }
            builder.append(BizLogicManagerBean.appendField(isWsiFound ? (String)wsi.getPerformingApp() : (String)ws.getPerformingApp(), "  Custom App.     : "));
            if (wiInfo.get(wsId) == null) continue;
            builder.append("    " + wiInfo.get(wsId)).append(LINE_SEPARATOR);
        }
        return builder;
    }

    private static String appendField(String fieldString, String message) {
        try {
            if (fieldString != null) {
                return message + fieldString + LINE_SEPARATOR;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return "";
    }

    public Hashtable getProcessInstanceList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            return this.getAllProcessInstanceList(ses, true, "ALL");
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getProcessInstanceList(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            return this.getAllProcessInstanceList(ses, false, ptName);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getProcessInstanceMilestone(String session, String piName) {
        throw new RuntimeException("This API getProcessInstanceMilestone is no longer supported in the class BizLogicManager from SBM 6.0.");
    }

    public String[] getProcessInstanceNameList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector piList = blServer.getActivatedProcessInstanceList((Session)ses).list;
            Vector<String> piNames = new Vector<String>();
            ProcessInstance pi = null;
            for (int ix = 0; ix < piList.size(); ++ix) {
                pi = (ProcessInstance)piList.elementAt(ix);
                piNames.addElement(pi.getName());
            }
            return piNames.toArray(new String[0]);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String[] getProcessInstanceNameList(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            long ptid = blServer.getProcessTemplate(ses, ptName).getID();
            Vector piList = blServer.getProcessInstanceList((Session)ses, (long)ptid).list;
            int size = piList.size();
            String[] piNames = new String[size];
            ProcessInstance pi = null;
            for (int ix = 0; ix < size; ++ix) {
                pi = (ProcessInstance)piList.elementAt(ix);
                piNames[ix] = pi.getName();
            }
            return piNames;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public PAKClientWorkitem[] getProcessInstanceWorkitem(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            Vector wiList = pi.getWorkItemList().list;
            PAKClientWorkitem[] ww = new PAKClientWorkitem[wiList.size()];
            int index = 0;
            WorkItem wi2 = null;
            for (WorkItem wi2 : wiList) {
                ww[index++] = BLMigrationUtil.getClientWorkitem(ses, wi2);
            }
            return ww;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getProcessInstanceWorkstepInfo(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            long piid = 0L;
            ProcessInstance pi = null;
            try {
                piid = BLMigrationUtil.getPIID(piName);
                pi = blServer.getProcessInstance(ses, piid);
            }
            catch (Exception ex) {
                pi = blServer.getProcessInstance(ses, piName);
                piid = pi.getID();
            }
            Vector wiList = pi.getWorkItemList().list;
            HashMap<Long, ArrayList<String>> wiMap = new HashMap<Long, ArrayList<String>>();
            WorkItem wi = null;
            for (int x = 0; x < wiList.size(); ++x) {
                wi = (WorkItem)wiList.get(x);
                long wsid = wi.getWorkStepID();
                ArrayList<String> performers = (ArrayList<String>)wiMap.get(wsid);
                if (performers == null) {
                    performers = new ArrayList<String>();
                }
                performers.add(wi.getPerformer());
                wiMap.put(wsid, performers);
            }
            wiList.clear();
            Vector v = new Vector();
            Vector wsList = pi.getWorkStepInstanceList().list;
            if (wsList == null || wsList.isEmpty()) {
                return v;
            }
            WorkStepInstance wsi2 = null;
            for (WorkStepInstance wsi2 : wsList) {
                Hashtable<String, Object> h = new Hashtable<String, Object>();
                BLConstants.single();
                h.put("PROCESSINSTANCEID", wsi2.getProcessInstanceID());
                BLConstants.single();
                h.put("PROCESSTEMPLATEID", wsi2.getProcessTemplateID());
                BLConstants.single();
                h.put("WORKSTEPNAME", wsi2.getName());
                if (wsi2.getPriority() != null) {
                    BLConstants.single();
                    h.put("PRIORITY", wsi2.getPriority());
                }
                BLConstants.single();
                h.put("TYPE", wsi2.getTypeString());
                long wsid = wsi2.getID();
                int status = wsi2.getState();
                int type = wsi2.getType();
                BLConstants.single();
                h.put("STATUS", BLMigrationUtil.getEventMessage(status, null));
                BLConstants.single();
                h.put("STARTTIME", wsi2.getStartTime());
                BLConstants.single();
                h.put("ENDTIME", wsi2.getCompleteTime());
                BLConstants.single();
                h.put("DUEDATE", wsi2.getDueDate().getTime());
                String wsperf = wsi2.getPerformer();
                if (wsperf != null) {
                    BLConstants.single();
                    h.put("PERFORMER", wsperf);
                } else {
                    BLConstants.single();
                    BLConstants.single();
                    h.put("PERFORMER", "");
                }
                BLConstants.single();
                h.put("DURATION", wsi2.getDuration());
                BLConstants.single();
                h.put("ISROLLBACKPOINT", wsi2.isRollbackPoint());
                BLConstants.single();
                h.put("LOOPCOUNTER", String.valueOf(wsi2.getLoopCounter()));
                BLConstants.single();
                if (type == 102) {
                    BLConstants.single();
                    if (status == 18) {
                        BLConstants.single();
                        h.put("PERFORMERS", ((List)wiMap.get(wsid)).toArray(new String[0]));
                    }
                }
                BLConstants.single();
                if (type == 108) {
                    BLConstants.single();
                    h.put("SUBPROCESSINSTANCENAME", "");
                    BLConstants.single();
                    h.put("SUBPROCESSTEMPLATENAME", wsperf);
                }
                v.addElement(h);
            }
            wsList.clear();
            return v;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getProcessInstanceXML(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getProcessInstance(ses, piName).getXML();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getUserCreatedProcessInstanceList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            return this.getUserCreatedPIList(ses, ses.getUser());
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getUserCreatedProcessInstanceList(String session, String user) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            return this.getUserCreatedPIList(ses, user);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public boolean isValidProcessInstance(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.isProcessInstanceExist(ses, piName);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public long removeAllProcessInstances(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptName);
            return pt.removeAllProcessInstance();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return -1L;
        }
    }

    public void removeProcessInstance(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            pi.remove();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void removeProcessInstance(String session, String piName, boolean forceRemove) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            pi.remove();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void resumeProcessInstance(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            pi.resume();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setProcessInstanceDuedate(String session, String piName, String duedate) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            pi.setDueDate(new DateTime(SBMUtil.self().getDateTime(duedate, false)));
            pi.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void suspendProcessInstance(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            pi.suspend();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setSubProcessInstanceName(String session, String piName, String wsName, String subPiName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            wsi.setSubProcessInstanceID(BLMigrationUtil.getPIID(subPiName));
            wsi.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public long createSubProcessInstance(String session, String caller, boolean updateCaller, String creator, String subPtName, String subPiName, String priority, HashMap dsValues, HashMap callerInfo) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            long piid = blServer.createSubProcessInstance(ses, subPtName, BLMigrationUtil.getPIPrefix(subPiName), priority, creator, dsValues, updateCaller, callerInfo);
            return piid;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return -1L;
        }
    }

    public void createWorkitemSubProcess(String session, String wiName, String subPtName, String subPiName, String priority, String[] inputMappings, String[] outputMappings, boolean updateCaller) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public Vector getWorkitemSubProcesses(String session, String piName) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void completeCallerWS(String session, String piName, String wsName, Hashtable dsValues) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            HashMap values = null;
            if (dsValues != null && !dsValues.isEmpty()) {
                values = new HashMap(dsValues);
            }
            blServer.completeCallerWorkStep(ses, wsi.getProcessInstanceID(), wsi.getID(), values);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public Hashtable getActiveWorkstepList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Hashtable<String, String[]> list = new Hashtable<String, String[]>();
            Vector piList = (Vector)blServer.getActivatedProcessInstanceList(ses).getList();
            ProcessInstance pi = null;
            for (int ix = piList.size() - 1; ix >= 0; --ix) {
                pi = (ProcessInstance)piList.elementAt(ix);
                list.put(pi.getName(), pi.getActivatedWorkStepNames());
            }
            return list;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getCompFunction(String session, String ptName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate wst = blServer.getWorkStepTemplate(ses, ptName, wsName);
            return wst.getCompJavaScript();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getPostFunction(String session, String ptName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate wst = blServer.getWorkStepTemplate(ses, ptName, wsName);
            return wst.getPostJavaScript();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getPreFunction(String session, String ptName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate wst = blServer.getWorkStepTemplate(ses, ptName, wsName);
            return wst.getPreJavaScript();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getReactivateWorkstepName(String session, String ptName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate wst = blServer.getWorkStepTemplate(ses, ptName, wsName);
            return wst.getReactivateWorkStepName();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getRollbackPoints(String session, String ptName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptName);
            return pt.getRollbackPoints();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getStartWorkstepName(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            return pi.getStartWorkstepName();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getSuspendedWorkstepList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector wsList = blServer.getSuspendedWorkStepInstanceList((Session)ses).list;
            Hashtable<String, String[]> list = new Hashtable<String, String[]>();
            Vector<Long> tmp = new Vector<Long>();
            WorkStepInstance wsi = null;
            ProcessInstance pi = null;
            String[] wsNames = null;
            for (int x = 0; x < wsList.size(); ++x) {
                wsi = (WorkStepInstance)wsList.get(x);
                long piid = wsi.getProcessInstanceID();
                if (tmp.contains(piid)) continue;
                pi = wsi.getParent();
                wsNames = pi.getSuspendedWorkStepNames();
                list.put(pi.getName(), wsNames);
                tmp.addElement(piid);
            }
            return list;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getSuspendedWorkstepList(String session, String pName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
            if (BLMigrationUtil.isProcessInstance(pName)) {
                ProcessInstance pi = blServer.getProcessInstance(ses, pName);
                ht.put(pName, pi.getSuspendedWorkStepNames());
                return ht;
            }
            ProcessTemplate pt = blServer.getProcessTemplate(ses, pName);
            Vector wsList = blServer.getSuspendedWorkStepInstanceList((Session)ses, (long)pt.getID()).list;
            Vector<Long> tmp = new Vector<Long>();
            WorkStepInstance wsi = null;
            ProcessInstance pi = null;
            String[] wsNames = null;
            for (int x = 0; x < wsList.size(); ++x) {
                wsi = (WorkStepInstance)wsList.get(x);
                long piid = wsi.getProcessInstanceID();
                if (tmp.contains(piid)) continue;
                pi = wsi.getParent();
                wsNames = pi.getSuspendedWorkStepNames();
                ht.put(pi.getName(), wsNames);
                tmp.addElement(piid);
            }
            return ht;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getUserCreatedActiveWorkstepList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLConstants.single();
            return this.getActiveSuspendedWorkstepList(ses, null, 18);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getUserCreatedActiveWorkstepList(String session, Vector ptList) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLConstants.single();
            return this.getActiveSuspendedWorkstepList(ses, ptList, 18);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getUserWorkstepList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            return this.getActiveSuspendedWorkstepList(ses, null, -1);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getUserWorkstepList(String session, Vector ptList) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            return this.getActiveSuspendedWorkstepList(ses, ptList, -1);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getWorkstepDuedate(String session, String piName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            return SBMUtil.self().getFormattedDate(wsi.getDueDate().getTime());
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getWorkstepFYI(String session, String pName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcess(ses, pName);
            return pt.getWorkStepTemplate(wsName).getFYI();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getWorkstepInfo(String session, String piName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate ws = blServer.getProcess(ses, piName).getWorkStepTemplate(wsName);
            long duration = ws.getDuration();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            long wsid = wsi.getID();
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            BLConstants.single();
            h.put("WORKSTEPNAME", wsi.getName());
            if (wsi.getPriority() != null) {
                BLConstants.single();
                h.put("PRIORITY", wsi.getPriority());
            }
            BLConstants.single();
            h.put("TYPE", wsi.getTypeString());
            int status = wsi.getState();
            BLConstants.single();
            h.put("STATUS", BLMigrationUtil.getEventMessage(status, null));
            BLConstants.single();
            h.put("STARTTIME", wsi.getStartTime());
            BLConstants.single();
            h.put("ENDTIME", wsi.getCompleteTime());
            BLConstants.single();
            h.put("DURATION", duration);
            if (wsi.getDueDate() != null) {
                BLConstants.single();
                h.put("DUEDATE", wsi.getDueDate().getValue().getTime());
            }
            BLConstants.single();
            h.put("ISROLLBACKPOINT", ws.isRollbackPoint());
            String wsperf = wsi.getPerformer();
            if (wsperf != null) {
                BLConstants.single();
                h.put("PERFORMER", wsperf);
            } else {
                BLConstants.single();
                BLConstants.single();
                h.put("PERFORMER", "");
            }
            BLConstants.single();
            h.put("LOOPCOUNTER", "-1");
            int n = wsi.getType();
            BLConstants.single();
            if (n == 102 && wsi.isActivated()) {
                Vector wiList = wsi.getParent().getWorkItemList().list;
                Iterator iter = wiList.iterator();
                String[] workItems = new String[wiList.size()];
                WorkItem wi = null;
                int index = 0;
                while (iter.hasNext()) {
                    wi = (WorkItem)iter.next();
                    if (wsid != wi.getWorkStepID()) continue;
                    workItems[index++] = wi.getName();
                }
                BLConstants.single();
                h.put("WORKITEMNAMES", workItems);
            }
            HashMap mappedNames = ws.getInputDataSlotNames();
            String[] inputDSNames = new String[mappedNames.size()];
            int index = 0;
            for (String actualName : mappedNames.keySet()) {
                String mappedName;
                if (actualName.equals(mappedName = (String)mappedNames.get(actualName))) {
                    inputDSNames[index++] = actualName;
                    continue;
                }
                int n2 = index++;
                StringBuilder stringBuilder = new StringBuilder().append(actualName);
                BLConstants.single();
                inputDSNames[n2] = stringBuilder.append("@").append(mappedName).toString();
            }
            BLConstants.single();
            h.put("INPUTDATASLOTS", inputDSNames);
            mappedNames = ws.getOutputDataSlotNames();
            String[] outputDSNames = new String[mappedNames.size()];
            index = 0;
            for (String actualName : mappedNames.keySet()) {
                String mappedName;
                if (actualName.equals(mappedName = (String)mappedNames.get(actualName))) {
                    outputDSNames[index++] = actualName;
                    continue;
                }
                int n3 = index++;
                StringBuilder stringBuilder = new StringBuilder().append(actualName);
                BLConstants.single();
                outputDSNames[n3] = stringBuilder.append("@").append(mappedName).toString();
            }
            BLConstants.single();
            h.put("OUTPUTDATASLOTS", outputDSNames);
            return h;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public String getWorkstepInstruction(String session, String pName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcess(ses, pName);
            return pt.getWorkStepTemplate(wsName).getInstruction();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public void reactivateWorkstep(String session, String piName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            wsi.reActivate();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void removeReactivateWorkstepName(String session, String ptName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate wst = blServer.getWorkStepTemplate(ses, ptName, wsName);
            wst.removeReactivateWorkStepName();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void resumeWorkstep(String session, String piName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            wsi.resume();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setCompFunction(String session, String ptName, String wsName, String compJScript) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate ws = blServer.getWorkStepTemplate(ses, ptName, wsName);
            ws.setCompJavaScript(compJScript);
            ws.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setPostFunction(String session, String ptName, String wsName, String postJScript) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate ws = blServer.getWorkStepTemplate(ses, ptName, wsName);
            ws.setPostJavaScript(postJScript);
            ws.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setPreCondition(String session, String pName, String wsName, String startCondition) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate wstSVO = blServer.getWorkStepTemplate(ses, pName, wsName);
            wstSVO.setPreCondition(startCondition);
            wstSVO.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setPreFunction(String session, String ptName, String wsName, String preJScript) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate ws = blServer.getWorkStepTemplate(ses, ptName, wsName);
            ws.setPreJavaScript(preJScript);
            ws.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setReactivateWorkstepName(String session, String ptName, String failureWSname, String reactivateWSname) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate ws = blServer.getWorkStepTemplate(ses, ptName, failureWSname);
            ws.setReactivateWorkStepName(reactivateWSname);
            ws.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setSaveDataslots(String session, String ptName, String wsName, Vector dsNames) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate ws = blServer.getWorkStepTemplate(ses, ptName, wsName);
            ws.setDataSlotCopyNames(dsNames);
            ws.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setStartWorkstep(String session, String piName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piName);
            pi.setStartWorkstepName(wsName);
            pi.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setWorkstepDuedate(String session, String piName, String wsName, long duedate) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            wsi.setDueDate(new DateTime(duedate));
            wsi.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setWorkstepDuedate(String session, String piName, String wsName, String duedate) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            wsi.setDueDate(new DateTime(duedate));
            wsi.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setWorkstepInstruction(String session, String pName, String wsName, String instruction) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcess(ses, pName);
            WorkStepTemplate ws = pt.getWorkStepTemplate(wsName);
            ws.setInstruction(instruction);
            ws.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setWorkstepPerformer(String session, String pName, String wsName, String performer) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            if (BLMigrationUtil.isProcessInstance(pName)) {
                WorkStepInstance wsi = blServer.getWorkStepInstance(ses, pName, wsName);
                wsi.setPerformer(performer);
                wsi.save();
            } else {
                WorkStepTemplate ws = blServer.getWorkStepTemplate(ses, pName, wsName);
                ws.setPerformer(performer);
                ws.save();
            }
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setWorkstepPerformer(String session, String pName, String wsName, String performer, boolean performedByAll) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate pt = blServer.getProcess(ses, pName);
            WorkStepTemplate ws = pt.getWorkStepTemplate(wsName);
            ws.setPerformer(performer, performedByAll);
            ws.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setWorkstepPriority(String session, String piName, String wsName, String priority) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            wsi.setPriority(priority);
            wsi.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void suspendWorkstep(String session, String piName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            wsi.suspend();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void assignWorkitemPerformer(String session, PAKClientWorkitem wiObject) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiObject.getName());
            wi.assign(ses.getUser());
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void completeWorkitem(String session, PAKClientWorkitem wiObject) {
        PAKClientData[] cd = wiObject.getAttachedData();
        HashMap<String, Object> dsmap = new HashMap<String, Object>();
        for (int x = 0; x < cd.length; ++x) {
            if (cd[x].isReadOnly()) continue;
            dsmap.put(cd[x].getName(), cd[x].getValue());
        }
        this.completeWorkitem(session, wiObject.getName(), dsmap);
    }

    public void completeWorkitem(String session, String wiName) {
        this.completeWorkitem(session, wiName, (Hashtable)null);
    }

    public void completeWorkitem(String session, String wiName, Hashtable dsValues) {
        HashMap values = null;
        if (dsValues != null && !dsValues.isEmpty()) {
            values = new HashMap(dsValues);
        }
        this.completeWorkitem(session, wiName, values);
    }

    private void completeWorkitem(String session, String wiName, HashMap dsValues) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            if (dsValues == null || dsValues.isEmpty()) {
                wi.complete();
            } else {
                wi.complete(dsValues);
            }
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void emailAssignedTaskWithWarning(String session, String wiName, String warning) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            blServer.emailAssignedTaskWithWarning(ses, wi.getID(), warning);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public PAKClientWorkitem getWorkitem(String session, String wiName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            PAKClientWorkitem pcw = BLMigrationUtil.getClientWorkitem(ses, wi);
            return pcw;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Object getWorkitemDataslotValue(String session, String wiName, String dsName) {
        return this.getWorkitemData(session, wiName, dsName);
    }

    public Object getWorkitemData(String session, String wiName, String dsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            return wi.getDataSlot(dsName).getValue();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Hashtable getWorkitemInfo(String session, String wiName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            HashMap attribs = wi.getAttributes();
            BLUtil.self();
            return BLUtil.convertToHashtable((HashMap)attribs);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public PAKClientWorkitem[] getWorkitemList(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector wiList = blServer.getWorkItemList((Session)ses, (String)ses.getUser()).list;
            if (wiList == null || wiList.isEmpty()) {
                return null;
            }
            PAKClientWorkitem[] ww = new PAKClientWorkitem[wiList.size()];
            int x = 0;
            for (WorkItem wi : wiList) {
                ww[x] = BLMigrationUtil.getClientWorkitem(ses, wi);
                ++x;
            }
            return ww;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public PAKClientWorkitem[] getWorkitemList(String session, String user) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector wiList = blServer.getWorkItemList((Session)ses, (String)user).list;
            if (wiList == null || wiList.isEmpty()) {
                return null;
            }
            PAKClientWorkitem[] ww = new PAKClientWorkitem[wiList.size()];
            int x = 0;
            for (WorkItem wi : wiList) {
                ww[x] = BLMigrationUtil.getClientWorkitem(ses, wi);
                ++x;
            }
            return ww;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getWorkitemList(String session, String piName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            Vector wiList = wsi.getWorkItemList().list;
            Vector<String[]> returnList = new Vector<String[]>();
            for (int ix = 0; ix < wiList.size(); ++ix) {
                WorkItem wi = (WorkItem)wiList.elementAt(ix);
                String[] item = new String[2];
                item[0] = wi.getName();
                StringBuffer performer = new StringBuffer();
                int n = wi.getState();
                BLConstants.single();
                if (n == 27) {
                    Vector performerList = wi.getAvailablePerformers();
                    if (performerList != null) {
                        for (int i = 0; i < performerList.size(); ++i) {
                            performer.append((String)performerList.elementAt(i));
                            performer.append("|");
                        }
                    }
                    item[1] = performer.toString();
                    item[1] = item[1].substring(0, item[1].length() - 1);
                } else {
                    item[1] = wi.getPerformer();
                }
                returnList.addElement(item);
            }
            return returnList;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public PAKClientWorkitem[] getWorkitemListWOData(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector wiList = blServer.getWorkItemList((Session)ses, (String)ses.getUser()).list;
            if (wiList == null || wiList.isEmpty()) {
                return null;
            }
            PAKClientWorkitem[] ww = new PAKClientWorkitem[wiList.size()];
            int x = 0;
            for (WorkItem wi : wiList) {
                ww[x] = BLMigrationUtil.getClientWorkitemWO(ses, wi);
                ++x;
            }
            return ww;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public PAKClientWorkitem[] getWorkitemListWOData(String session, String user) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector wiList = blServer.getWorkItemList((Session)ses, (String)user).list;
            if (wiList == null || wiList.isEmpty()) {
                return null;
            }
            PAKClientWorkitem[] ww = new PAKClientWorkitem[wiList.size()];
            int x = 0;
            for (WorkItem wi : wiList) {
                ww[x] = BLMigrationUtil.getClientWorkitemWO(ses, wi);
                ++x;
            }
            return ww;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public boolean isEmailSupportEnabled(String session, String wiName) {
        return this.getEmailSupport(session, wiName);
    }

    public boolean getEmailSupport(String session, String wiName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            return wi.getEmailSupport();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return false;
        }
    }

    public boolean isWorkitemAssigned(String session, String wiName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            int n = wi.getState();
            BLConstants.single();
            return n == 28;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return false;
        }
    }

    public void reassignWorkitemPerformer(String session, String wiName, String performer) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            wi.reAssign(performer);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setAllWorkitemData(String session, PAKClientWorkitem wiObject) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiObject.getName());
            HashMap<String, Object> map = new HashMap<String, Object>();
            PAKClientData[] cd = wiObject.getAttachedData();
            for (int x = 0; x < cd.length; ++x) {
                if (cd[x].isReadOnly()) continue;
                map.put(cd[x].getName(), cd[x].getValue());
            }
            long piid = wi.getProcessInstanceID();
            ProcessInstance pi = blServer.getProcessInstance(ses, piid);
            pi.updateSlotValue(map);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setWorkitemDataslot(String session, String wiName, String dsName, String data) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            DataSlot ds = wi.getDataSlot(dsName);
            if (ds.isDateTime()) {
                ds.setValue(new DateTime(data));
            } else if (ds.isDecimal()) {
                ds.setValue(new Decimal(data));
            } else if (ds.isXML()) {
                ds.setValue(new XML(data));
            } else {
                ds.setValue(data);
            }
            ds.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void setWorkitemDataslot(String session, String wiName, String dsName, Object data) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            DataSlot ds = wi.getDataSlot(dsName);
            ds.setValue(data);
            ds.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void updateWorkitemsPerformer(String session, String oldPerformer, String newPerformer) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            blServer.reAssign(ses, oldPerformer, newPerformer);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void updateAvailableWorkitemPerformers(String session, String wiName, String performer) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector<String> performers = new Vector<String>();
            BLConstants.single();
            StringTokenizer str = new StringTokenizer(performer, "|");
            while (str.hasMoreTokens()) {
                performers.addElement(str.nextToken());
            }
            WorkItem wiObject = blServer.getWorkItem(ses, wiName);
            blServer.makeAvailable(ses, wiObject.getProcessInstanceID(), wiObject.getWorkStepID(), performers);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public Vector setProcessInstancesAttributes(String session, String[] piNames, String[] attList, Vector valuesList) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            if (piNames == null || attList == null || valuesList == null) {
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2693", "setProcessInstancesAttributes");
            }
            if (attList.length != valuesList.size()) {
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2692", "setProcessInstancesAttributes");
            }
            for (int y = 0; y < valuesList.size(); ++y) {
                String[] values = (String[])valuesList.elementAt(y);
                if (values.length == piNames.length || values.length == 1) continue;
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2692", "setProcessInstancesAttributes");
            }
            Vector<String> errMsg = new Vector<String>();
            BLServer blServer = BLMigrationUtil.getBLServer();
            for (int x = 0; x < piNames.length; ++x) {
                ProcessInstance pi = blServer.getProcessInstance(ses, piNames[x]);
                try {
                    for (int ix = 0; ix < attList.length; ++ix) {
                        String[] valueList = (String[])valuesList.elementAt(ix);
                        String value = valueList.length > 1 ? valueList[x] : valueList[0];
                        if (attList[ix].equalsIgnoreCase("manager")) continue;
                        if (attList[ix].equalsIgnoreCase("creator")) {
                            pi.setCreator(value);
                            continue;
                        }
                        if (attList[ix].equalsIgnoreCase("description")) continue;
                        if (attList[ix].equalsIgnoreCase("priority")) {
                            pi.setPriority(value);
                            continue;
                        }
                        if (attList[ix].equalsIgnoreCase("duedate")) {
                            pi.setDueDate(new DateTime(value));
                            continue;
                        }
                        if (!attList[ix].equalsIgnoreCase("status")) continue;
                        if (value.equalsIgnoreCase("PI_SUSPENDED")) {
                            int n = pi.getState();
                            BLConstants.single();
                            if (n != 7) continue;
                            pi.suspend();
                            continue;
                        }
                        if (!value.equalsIgnoreCase("PI_ACTIVATED")) continue;
                        int n = pi.getState();
                        BLConstants.single();
                        if (n != 8) continue;
                        pi.resume();
                    }
                    pi.save();
                    continue;
                }
                catch (Exception ex) {
                    errMsg.addElement(ex.getMessage());
                    int n = blServer.getServerState();
                    BLConstants.single();
                    if (n != 6) continue;
                    StringBuffer dberr = new StringBuffer();
                    dberr.append("BizLogic Server has been suspended because of database exception, the update on the following process isntances is failed: ");
                    for (int index = x; index < piNames.length; ++index) {
                        dberr.append(piNames[index]);
                        if (index != piNames.length - 1) {
                            dberr.append(", ");
                            continue;
                        }
                        dberr.append(".");
                    }
                    errMsg.addElement(dberr.toString());
                    return errMsg;
                }
            }
            return errMsg;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector setProcessInstancesDataslotsValue(String session, String[] piNames, String[] dsNames, Vector valuesList) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            if (piNames == null || dsNames == null || valuesList == null) {
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2693", "setProcessInstancesDataslotsValue");
            }
            if (dsNames.length != valuesList.size()) {
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2692", "setProcessInstancesDataslotsValue");
            }
            for (int y = 0; y < valuesList.size(); ++y) {
                Object[] values = (Object[])valuesList.elementAt(y);
                if (values.length == piNames.length || values.length == 1) continue;
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2692", "setProcessInstancesDataslotsValue");
            }
            Vector<String> errMsg = new Vector<String>();
            BLServer blServer = BLMigrationUtil.getBLServer();
            for (int x = 0; x < piNames.length; ++x) {
                ProcessInstance pi = blServer.getProcessInstance(ses, piNames[x]);
                try {
                    HashMap<String, Object> dsMap = new HashMap<String, Object>();
                    for (int ix = 0; ix < dsNames.length; ++ix) {
                        Object[] valueList = (Object[])valuesList.elementAt(ix);
                        Object value = valueList.length > 1 ? valueList[x] : valueList[0];
                        dsMap.put(dsNames[ix], value);
                    }
                    pi.updateSlotValue(dsMap);
                    continue;
                }
                catch (Exception ex) {
                    errMsg.addElement(ex.getMessage());
                    int n = blServer.getServerState();
                    BLConstants.single();
                    if (n != 6) continue;
                    StringBuffer dberr = new StringBuffer();
                    dberr.append("BizLogic Server has been suspended because of database exception, the update on the following process isntances is failed: ");
                    for (int index = x; index < piNames.length; ++index) {
                        dberr.append(piNames[index]);
                        if (index != piNames.length - 1) {
                            dberr.append(", ");
                            continue;
                        }
                        dberr.append(".");
                    }
                    errMsg.addElement(dberr.toString());
                    return errMsg;
                }
            }
            return errMsg;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector setWorkstepsAttributes(String session, String[] piNames, String[] wsNames, String[] attList, Vector valuesList) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            if (piNames == null || wsNames == null || attList == null || valuesList == null) {
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2693", "setWorkstepsAttributes");
            }
            if (piNames.length != wsNames.length || attList.length != valuesList.size()) {
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2692", "setWorkstepsAttributes");
            }
            for (int y = 0; y < valuesList.size(); ++y) {
                String[] values = (String[])valuesList.elementAt(y);
                if (values.length == piNames.length || values.length == 1) continue;
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2692", "setWorkstepsAttributes");
            }
            Vector<String> errMsg = new Vector<String>();
            BLServer blServer = BLMigrationUtil.getBLServer();
            for (int x = 0; x < piNames.length; ++x) {
                ProcessInstance pi = blServer.getProcessInstance(ses, piNames[x]);
                WorkStepInstance ws = blServer.getWorkStepInstance(ses, piNames[x], wsNames[x]);
                try {
                    ProcessInstance processInstance = pi;
                    synchronized (processInstance) {
                        for (int ix = 0; ix < attList.length; ++ix) {
                            String[] valueList = (String[])valuesList.elementAt(ix);
                            String value = valueList.length > 1 ? valueList[x] : valueList[0];
                            if (attList[ix].equalsIgnoreCase("performer")) {
                                ws.setPerformer(value);
                                continue;
                            }
                            if (attList[ix].equalsIgnoreCase("status")) {
                                ws.save();
                                int state = ws.getState();
                                if (value.equalsIgnoreCase("W_SUSPENDED")) {
                                    BLConstants.single();
                                    if (state == 18) {
                                        ws.suspend();
                                        continue;
                                    }
                                    BLConstants.single();
                                    if (state == 16) continue;
                                    PAKExceptionServer.throwPAKException("BizLogic_ERR_2565", new String[]{piNames[x], wsNames[x]});
                                    continue;
                                }
                                if (!value.equalsIgnoreCase("W_ACTIVATED")) continue;
                                BLConstants.single();
                                if (state == 16) {
                                    ws.resume();
                                    continue;
                                }
                                BLConstants.single();
                                if (state == 18) continue;
                                PAKExceptionServer.throwPAKException("BizLogic_ERR_2695", new String[]{piNames[x], wsNames[x]});
                                continue;
                            }
                            if (attList[ix].equalsIgnoreCase("priority")) {
                                ws.setPriority(value);
                                continue;
                            }
                            if (!attList[ix].equalsIgnoreCase("duedate")) continue;
                            ws.setDueDate(new DateTime(value));
                        }
                        ws.save();
                        continue;
                    }
                }
                catch (Exception ex) {
                    errMsg.addElement(ex.getMessage());
                    int n = blServer.getServerState();
                    BLConstants.single();
                    if (n != 6) continue;
                    StringBuffer dberr = new StringBuffer();
                    dberr.append("BizLogic Server has been suspended because of database exception, the update on the following process isntances is failed: ");
                    for (int index = x; index < piNames.length; ++index) {
                        dberr.append(piNames[index]);
                        if (index != piNames.length - 1) {
                            dberr.append(", ");
                            continue;
                        }
                        dberr.append(".");
                    }
                    errMsg.addElement(dberr.toString());
                    return errMsg;
                }
            }
            return errMsg;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector reassignWorkitems(String session, String[] wiNames, String[] performers) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            if (wiNames == null || performers == null) {
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2693", "reassignWorkitemsPerformer");
            }
            if (wiNames.length != performers.length && performers.length != 1) {
                PAKExceptionServer.throwPAKException("BizLogic_ERR_2692", "reassignWorkitemsPerformer");
            }
            Vector<String> errMsg = new Vector<String>();
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = null;
            for (int x = 0; x < wiNames.length; ++x) {
                try {
                    wi = blServer.getWorkItem(ses, wiNames[x]);
                    if (performers.length == 1) {
                        wi.reAssign(performers[0]);
                        continue;
                    }
                    wi.reAssign(performers[x]);
                    continue;
                }
                catch (Exception ex) {
                    errMsg.addElement(ex.getMessage());
                    int n = blServer.getServerState();
                    BLConstants.single();
                    if (n != 6) continue;
                    StringBuffer dberr = new StringBuffer();
                    dberr.append("BizLogic Server has been suspended because of database exception, the update on the following workitem's reassignment is failed: ");
                    for (int index = x; index < wiNames.length; ++index) {
                        dberr.append(wiNames[index]);
                        if (index != wiNames.length - 1) {
                            dberr.append(", ");
                            continue;
                        }
                        dberr.append(".");
                    }
                    errMsg.addElement(dberr.toString());
                }
            }
            return errMsg;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    private Hashtable getUserCreatedPIList(Session ses, String user) throws RemoteException, BizLogicClientException {
        BLServer blServer = BLMigrationUtil.getBLServer();
        Vector v = blServer.getProcessInstanceList((Session)ses, (String)user).list;
        Hashtable<String, String[]> h = new Hashtable<String, String[]>();
        ProcessInstance pi = null;
        for (int x = 0; x < v.size(); ++x) {
            pi = (ProcessInstance)v.elementAt(x);
            BLConstants.single();
            if (7 != pi.getState()) continue;
            long ptid = pi.getProcessTemplateID();
            String piName = pi.getName();
            String[] tm = new String[]{pi.getProcessTemplateName(), BLUtil.getPILabelString((String)piName)};
            h.put(piName, tm);
        }
        return h;
    }

    private Hashtable getAllProcessInstanceList(Session ses, boolean isAllPT, String scope) throws RemoteException, BizLogicClientException {
        Hashtable hpi;
        String CPT = "Created_Process_Template";
        String IPT = "Installed_Process_Template";
        String SPT = "Suspended_Process_Template";
        String RPT = "Removed_Process_Template";
        String CPI = "Created_Process_Instance";
        String API = "Active_Process_Instance";
        String SPI = "Suspended_Process_Instance";
        Hashtable<String, Hashtable> hpt = new Hashtable<String, Hashtable>();
        int ptStatus = -1;
        long ptid = -1L;
        Vector PIList = null;
        BLServer blServer = BLMigrationUtil.getBLServer();
        if (!isAllPT) {
            ProcessTemplate pt = null;
            try {
                pt = blServer.getProcessTemplate(ses, scope);
            }
            catch (Exception ex) {
                PAKExceptionServer.throwPAKException("BizLogic_ERR_519", new Object[]{scope}, ex);
            }
            ptid = pt.getID();
            ptStatus = pt.getState();
            Hashtable<String, String> hpi2 = new Hashtable<String, String>();
            BLConstants.single();
            if (ptStatus == 1) {
                hpi2.put(scope, CPT);
            } else {
                BLConstants.single();
                if (ptStatus == 2) {
                    hpi2.put(scope, IPT);
                } else {
                    BLConstants.single();
                    if (ptStatus == 4) {
                        hpi2.put(scope, SPT);
                    }
                }
            }
            hpt.put(scope, hpi2);
            PIList = blServer.getProcessInstanceList((Session)ses, (long)ptid).list;
        } else {
            Vector PTList = blServer.getProcessTemplateList((Session)ses).list;
            for (ProcessTemplate pt : PTList) {
                String ptName = pt.getName();
                ptStatus = pt.getState();
                hpi = new Hashtable();
                BLConstants.single();
                if (ptStatus == 1) {
                    hpi.put(ptName, CPT);
                } else {
                    BLConstants.single();
                    if (ptStatus == 2) {
                        hpi.put(ptName, IPT);
                    } else {
                        BLConstants.single();
                        if (ptStatus == 4) {
                            hpi.put(ptName, SPT);
                        }
                    }
                }
                hpt.put(ptName, hpi);
            }
            PIList = blServer.getProcessInstanceList((Session)ses).list;
        }
        for (int x = 0; x < PIList.size(); ++x) {
            ProcessInstance pi = (ProcessInstance)PIList.elementAt(x);
            String processTemplateName = pi.getProcessTemplateName();
            if (!isAllPT && ptid != pi.getProcessTemplateID() || (hpi = (Hashtable)hpt.get(processTemplateName)) == null) continue;
            int piStatus = pi.getState();
            String piName = pi.getName();
            BLConstants.single();
            if (piStatus == 6) {
                hpi.put(piName, CPI);
                continue;
            }
            BLConstants.single();
            if (piStatus == 8) {
                hpi.put(piName, SPI);
                continue;
            }
            hpi.put(piName, API);
        }
        return hpt;
    }

    private Vector getPICountInfo(Session ses, String user) throws RemoteException, BizLogicClientException {
        Vector piCount = new Vector();
        BLServer blServer = BLMigrationUtil.getBLServer();
        ProcessCountList pcl = blServer.getProcessCountList(ses, user);
        Hashtable<String, Integer> userCreatedPICount = new Hashtable<String, Integer>();
        Hashtable<String, Integer> userToDoPICount = new Hashtable<String, Integer>();
        HashMap wiassign = pcl.getAssignWorkItemCount();
        HashMap wiavailable = pcl.getAvailableWorkItemCount();
        HashMap piactive = pcl.getActiveProcessInstanceCount();
        HashMap pisuspend = pcl.getSuspendProcessInstanceCount();
        String displayName2 = null;
        Integer Count = null;
        int count = 0;
        for (String displayName2 : wiassign.keySet()) {
            Count = (Integer)wiassign.get(displayName2);
            count = Count;
            Count = (Integer)wiavailable.get(displayName2);
            if ((count += Count.intValue()) != 0) {
                userToDoPICount.put(displayName2, count);
            }
            Count = (Integer)piactive.get(displayName2);
            count = Count;
            Count = (Integer)pisuspend.get(displayName2);
            if ((count += Count.intValue()) == 0) continue;
            userCreatedPICount.put(displayName2, count);
        }
        piCount.addElement(userToDoPICount);
        piCount.addElement(userCreatedPICount);
        return piCount;
    }

    private Vector getActiveSuspendedWorkstepList(Session ses, Vector ptList, int status) throws RemoteException, BizLogicClientException {
        String user = ses.getUser();
        Vector vPIsInfoList = new Vector();
        BLServer blServer = BLMigrationUtil.getBLServer();
        Vector wiList = blServer.getWorkStepInstanceList((Session)ses, (String)user).list;
        int tsize = wiList.size();
        for (int x = 0; x < tsize; ++x) {
            WorkStepInstance task = (WorkStepInstance)wiList.get(x);
            BLConstants.single();
            if (status == 18 && !task.isActivated()) continue;
            int wsType = task.getType();
            if (ptList != null && ptList.indexOf(task.getProcessTemplateName()) == -1) continue;
            long ptid = task.getProcessTemplateID();
            ProcessTemplate pt = blServer.getProcessTemplate(ses, ptid);
            long piid = task.getProcessInstanceID();
            ProcessInstance pi = blServer.getProcessInstance(ses, piid);
            Hashtable<String, Object> hPIInfo = new Hashtable<String, Object>();
            hPIInfo.put("PROCESSINSTANCENAME", task.getProcessInstanceName());
            hPIInfo.put("PROCESSTEMPLATENAME", task.getProcessTemplateName());
            hPIInfo.put("WORKSTEPNAME", task.getName());
            BLConstants.single();
            hPIInfo.put("APP_NAME", pt.getDisplayName());
            BLConstants.single();
            if (wsType == 102) {
                hPIInfo.put("WORKSTEPTYPE", "Activity");
            } else {
                BLConstants.single();
                if (wsType == 107) {
                    hPIInfo.put("WORKSTEPTYPE", "Adapter");
                } else {
                    BLConstants.single();
                    if (wsType == 100) {
                        hPIInfo.put("WORKSTEPTYPE", "Start");
                    } else {
                        hPIInfo.put("WORKSTEPTYPE", "SubProcess");
                    }
                }
            }
            if (task.isActivated()) {
                hPIInfo.put("WORKSTEPSTATUS", "Activated");
            } else {
                hPIInfo.put("WORKSTEPSTATUS", "Suspended");
            }
            String performer = task.getPerformer();
            if (performer == null) {
                BLConstants.single();
                if (wsType == 100) {
                    hPIInfo.put("PERFORMER", pi.getCreator());
                } else {
                    BLConstants.single();
                    if (wsType == 108) {
                        hPIInfo.put("PERFORMER", "SubProcess");
                    } else {
                        hPIInfo.put("PERFORMER", "<NULL>");
                    }
                }
            } else {
                BLConstants.single();
                if (wsType == 108) {
                    hPIInfo.put("PERFORMER", "SubProcess");
                } else {
                    hPIInfo.put("PERFORMER", performer);
                }
            }
            String priority = task.getPriority();
            if (priority == null) {
                hPIInfo.put("PRIORITY", "<NULL>");
            } else {
                hPIInfo.put("PRIORITY", priority);
            }
            hPIInfo.put("STARTDATE", task.getStartTime());
            hPIInfo.put("DUEDATE", task.getDueDate().getValue().getTime());
            vPIsInfoList.addElement(hPIInfo);
        }
        return vPIsInfoList;
    }

    public void start(String username) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public Hashtable getBizLogicHeapMemory() {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void runGarbageCollector() {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void checkConnection() {
        try {
            BLServer blServer = BLMigrationUtil.getBLServer();
            blServer.ping();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public String connect() {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public String connect(String userID) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public String getDecisionCondition(String session, String pName, String linkName) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void setDecisionCondition(String session, String ptName, String linkName, String conditionQuery) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void addListener(String session, String listener, int eventType, boolean syncMode) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void addListener(String session, String listener, int[] eventTypes, boolean syncMode) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void removeListener(String session, int listenerID) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public String getListenerList(String session) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void restoreDBConnections(String userID, String password) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void suspendDBConnections(String session) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void backup(String session) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public String[] filterUserGroups(String session, String[] groupNames) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public String getUserManagerClassName(String session) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void setProcessAutoPagingFlag(String session, String ptName, boolean flag) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public long getProcessInstanceSize(String session, String piName) {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void startBLEmailListener() throws EJBException, PAKException {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public void stopBLEmailListener() throws EJBException, PAKException {
        throw new RuntimeException("This method is not supported in BizLogic 4.0");
    }

    public WorkItem getWorkitem(String session, String piName, String wsName, long wiID) throws EJBException, PAKException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getWorkItem(ses, wiID);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public WorkItemList getWorkItemList(String session, String piName, String wsName) throws EJBException, PAKException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsi = blServer.getWorkStepInstance(ses, piName, wsName);
            return wsi.getWorkItemList();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public void removeWorkItem(String session, String piName, String wsName, long wiID) throws EJBException, PAKException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiID);
            wi.remove();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void addWorkItem(String session, String piName, String wsName, String wiPerformer, String wiSuffix, int priority, long duedate) throws EJBException, PAKException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepInstance wsiObject = blServer.getWorkStepInstance(ses, piName, wsName);
            wsiObject.addWorkItem(wiPerformer, wiSuffix, priority, duedate);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public ProcessTemplate createVersion(String session, String ptName, String xmlFileName) throws EJBException, PAKException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate ptSVO = blServer.getProcessTemplate(ses, ptName);
            return ptSVO.createVersion(xmlFileName);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public ProcessTemplateList getVersions(String session, String ptName) throws EJBException, PAKException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate ptSVO = blServer.getProcessTemplate(ses, ptName);
            return ptSVO.getVersions();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public boolean isSuspendedBySeqVersion(String session, String ptName) throws EJBException, PAKException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate ptSVO = blServer.getProcessTemplate(ses, ptName);
            return ptSVO.isSuspendedBySeqVersion();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return false;
        }
    }

    public void setDisplayName(String session, String ptName, String displayName) throws EJBException, PAKException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate ptSVO = blServer.getProcessTemplate(ses, ptName);
            ptSVO.setDisplayName(displayName);
            ptSVO.save();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public String getDisplayName(String session, String ptName) throws EJBException, PAKException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessTemplate ptSVO = blServer.getProcessTemplate(ses, ptName);
            return ptSVO.getDisplayName();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public long getXMLCollectionID(String session, long docid) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getXMLCollectionID(ses, docid);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return -1L;
        }
    }

    public String getXMLContent(String session, long docid) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getXMLContent(ses, docid);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public Vector getProcessTemplateInfo(String session) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            Vector ptList = blServer.getProcessTemplateList((Session)ses).list;
            Vector infoList = new Vector();
            for (ProcessTemplate pt : ptList) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                if (pt.getName() != null) {
                    BLConstants.single();
                    info.put("NAME", pt.getName());
                }
                if (pt.getCategory() != null) {
                    info.put("CATEGORY", pt.getCategory());
                }
                if (pt.getGroup() != null) {
                    info.put("GROUP", pt.getGroup());
                }
                if (pt.getDescription() != null) {
                    info.put("DESCRIPTION", pt.getDescription());
                }
                if (pt.getInfo() != null) {
                    info.put("INFO", pt.getInfo());
                }
                if (pt.getFYI() != null) {
                    info.put("FYI", pt.getFYI());
                }
                if (pt.getDisplayName() != null) {
                    info.put("APP_NAME", pt.getDisplayName());
                }
                BLConstants.single();
                info.put("STATUS", BLConstants.single().wfStates[pt.getState()]);
                if (!pt.isDynamic()) {
                    if (pt.isSuspendedBySeqVersion()) {
                        BLConstants.single();
                        info.put("ISSUSPENDEDBYVERSION", Boolean.TRUE);
                    }
                    if (pt.getParent() != null) {
                        BLConstants.single();
                        info.put("PARENT_NAME", pt.getParent().getName());
                    }
                } else {
                    BLConstants.single();
                    info.put("ISSUSPENDEDBYVERSION", Boolean.FALSE);
                    BLConstants.single();
                    info.put("PARENT_NAME", pt.getDynamicInstanceID() + "");
                }
                infoList.add(info);
            }
            return infoList;
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public void createDynamicProcessInstance(String session, long piid, String xml, boolean removeOnCompletion) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piid);
            pi.create(xml, removeOnCompletion);
        }
        catch (Exception ex) {
            PAKExceptionServer.throwPAKException(ex);
        }
    }

    public HashMap getProcessInstanceXMLWithData(String session, long piid) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            ProcessInstance pi = blServer.getProcessInstance(ses, piid);
            return pi.getXMLWithData();
        }
        catch (Exception ex) {
            PAKExceptionServer.throwPAKException(ex);
            return null;
        }
    }

    public String getPreCondition(String session, String ptName, String wsName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkStepTemplate wstSVO = blServer.getWorkStepTemplate(ses, ptName, wsName);
            return wstSVO.getPreCondition();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public ProcessInstance getProcessInstance(String session, String piName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.getProcessInstance(ses, piName);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return null;
        }
    }

    public boolean isProcessInstanceExist(String session, String piName) throws RemoteException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.isProcessInstanceExist(ses, piName);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return false;
        }
    }

    public boolean isProcessTemplateExist(String session, String ptName) throws RemoteException {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            return blServer.isProcessTemplateExist(ses, ptName);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
            return false;
        }
    }

    public void makeAvailable(String session, String wiName) {
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            wi.makeAvailable();
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public void makeAvailable(String session, String wiName, String performers) {
        if (performers == null) {
            this.makeAvailable(session, wiName);
        }
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiName);
            Vector<String> perfs = new Vector<String>();
            StringTokenizer stk = new StringTokenizer(performers, ",");
            while (stk.hasMoreTokens()) {
                perfs.add(stk.nextToken().trim());
            }
            wi.makeAvailable(perfs);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
    }

    public Session getSession(String sessionId) {
        return BLMigrationUtil.getSession(sessionId);
    }

    public PAKClientWorkitem getWorkitem(String session, long wiID) {
        PAKClientWorkitem pcw = null;
        try {
            Session ses = BLMigrationUtil.getSession(session);
            BLServer blServer = BLMigrationUtil.getBLServer();
            WorkItem wi = blServer.getWorkItem(ses, wiID);
            pcw = BLMigrationUtil.getClientWorkitem(ses, wi);
        }
        catch (Exception e) {
            PAKExceptionServer.throwPAKException(e);
        }
        return pcw;
    }
}

